/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.session.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class CASSPSession
extends BasicSPSession {
    @Nonnull
    @NotEmpty
    private final String ticket;
    @Nonnull
    @NotEmpty
    private final String serviceURL;

    public CASSPSession(@Nonnull @NotEmpty String id, @Nonnull Instant creation, @Nonnull Instant expiration, @Nonnull @NotEmpty String ticketId, @Nonnull @NotEmpty String url) {
        super(id, creation, expiration);
        this.ticket = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)ticketId), (String)"Ticket ID cannot be null or empty");
        this.serviceURL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)url), (String)"Service URL cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getTicketId() {
        return this.ticket;
    }

    @Nonnull
    @NotEmpty
    public String getServiceURL() {
        return this.serviceURL;
    }

    @Nullable
    public String getSPSessionKey() {
        return this.ticket;
    }

    @Nullable
    @NotEmpty
    public String getProtocol() {
        return "https://www.apereo.org/cas/protocol";
    }

    public boolean supportsLogoutPropagation() {
        return true;
    }

    public String toString() {
        return "CASSPSession: " + this.getId() + " via " + this.ticket + " at service URL " + this.serviceURL;
    }
}

