/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.impl;

import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.idp.cas.ticket.serialization.impl.ProxyGrantingTicketSerializer;
import net.shibboleth.idp.cas.ticket.serialization.impl.ProxyTicketSerializer;
import net.shibboleth.idp.cas.ticket.serialization.impl.ServiceTicketSerializer;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public abstract class AbstractTicketService
implements TicketService {
    @Nonnull
    private static final Map<Class<? extends Ticket>, String> CONTEXT_CLASS_MAP = new HashMap<Class<? extends Ticket>, String>();
    @Nonnull
    private static final Map<Class<? extends Ticket>, StorageSerializer<? extends Ticket>> SERIALIZER_MAP = new HashMap<Class<? extends Ticket>, StorageSerializer<? extends Ticket>>();
    @Nonnull
    private static final ServiceTicketSerializer ST_SERIALIZER = new ServiceTicketSerializer();
    @Nonnull
    private static final ProxyTicketSerializer PT_SERIALIZER = new ProxyTicketSerializer();
    @Nonnull
    private static final ProxyGrantingTicketSerializer PGT_SERIALIZER = new ProxyGrantingTicketSerializer();
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractTicketService.class);
    @Nonnull
    private final StorageService storageService;

    public AbstractTicketService(@Nonnull StorageService service) {
        this.storageService = (StorageService)Constraint.isNotNull((Object)service, (String)"StorageService cannot be null.");
    }

    @Nonnull
    public ProxyGrantingTicket createProxyGrantingTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull ServiceTicket serviceTicket, @Nonnull String pgtUrl) {
        Constraint.isNotNull((Object)serviceTicket, (String)"ServiceTicket cannot be null");
        ProxyGrantingTicket pgt = new ProxyGrantingTicket((String)Constraint.isNotNull((Object)id, (String)"ID cannot be null"), serviceTicket.getService(), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), (String)Constraint.isNotNull((Object)pgtUrl, (String)"pgtURL cannot be null"), null);
        pgt.setTicketState(serviceTicket.getTicketState());
        this.store(pgt);
        return pgt;
    }

    @Nonnull
    public ProxyGrantingTicket createProxyGrantingTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull ProxyTicket proxyTicket, @Nonnull String pgtUrl) {
        Constraint.isNotNull((Object)proxyTicket, (String)"ProxyTicket cannot be null");
        ProxyGrantingTicket pgt = new ProxyGrantingTicket((String)Constraint.isNotNull((Object)id, (String)"ID cannot be null"), proxyTicket.getService(), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), (String)Constraint.isNotNull((Object)pgtUrl, (String)"pgtURL cannot be null"), proxyTicket.getPgtId());
        pgt.setTicketState(proxyTicket.getTicketState());
        this.store(pgt);
        return pgt;
    }

    @Nullable
    public ProxyGrantingTicket fetchProxyGrantingTicket(@Nonnull String id) {
        Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        return this.read(id, ProxyGrantingTicket.class);
    }

    @Nullable
    public ProxyGrantingTicket removeProxyGrantingTicket(@Nonnull String id) {
        Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        ProxyGrantingTicket pgt = this.delete(id, ProxyGrantingTicket.class);
        return pgt;
    }

    @Nullable
    protected static String context(@Nonnull Class<? extends Ticket> clazz) {
        return CONTEXT_CLASS_MAP.get(clazz);
    }

    @Nonnull
    protected static <T extends Ticket> StorageSerializer<T> serializer(@Nonnull Class<T> clazz) {
        StorageSerializer result = (StorageSerializer)Constraint.isNotNull(SERIALIZER_MAP.get(clazz), (String)("Serializer for " + clazz + " not found"));
        return result;
    }

    protected <T extends Ticket> void store(@Nonnull T ticket) {
        try {
            String ticketCtx;
            String sessionId = ticket.getSessionId();
            long expiry = ticket.getExpirationInstant().toEpochMilli();
            if (sessionId != null) {
                String context = AbstractTicketService.context(ticket.getClass());
                this.log.debug("Storing mapping of {} to {} in context {}", new Object[]{ticket, sessionId, context});
                if (!this.storageService.create(context, ticket.getId(), sessionId, Long.valueOf(expiry))) {
                    throw new RuntimeException("Failed to store ticket " + ticket);
                }
                ticketCtx = sessionId;
            } else {
                ticketCtx = ticket.getId();
            }
            this.log.debug("Storing {} in context {}", ticket, (Object)ticketCtx);
            if (!this.storageService.create(ticketCtx, ticket.getId(), ticket, AbstractTicketService.serializer(ticket.getClass()), Long.valueOf(expiry))) {
                throw new RuntimeException("Failed to store ticket " + ticket);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to store ticket " + ticket, e);
        }
    }

    @Nullable
    protected <T extends Ticket> T read(@Nonnull String id, @Nonnull Class<T> clazz) {
        Ticket ticket;
        this.log.debug("Reading {}", (Object)id);
        try {
            String context;
            StorageRecord sessionRecord = this.storageService.read(AbstractTicketService.context(clazz), id);
            if (sessionRecord != null) {
                context = sessionRecord.getValue();
                this.log.debug("{} bound to session {}", (Object)id, (Object)context);
            } else {
                this.log.debug("{} not bound to any session. Using ticket ID for context.", (Object)id);
                context = id;
            }
            StorageRecord ticketRecord = this.storageService.read(context, id);
            if (ticketRecord == null) {
                this.log.debug("{} not found in context {}", (Object)id, (Object)context);
                return null;
            }
            ticket = (Ticket)ticketRecord.getValue(AbstractTicketService.serializer(clazz), context, id);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading ticket.");
        }
        return (T)ticket;
    }

    @Nullable
    protected <T extends Ticket> T delete(@Nonnull String id, @Nonnull Class<T> clazz) {
        T ticket = this.read(id, clazz);
        if (ticket == null) {
            return null;
        }
        try {
            String ticketCtx;
            String context = AbstractTicketService.context(clazz);
            String sessionId = ticket.getSessionId();
            if (sessionId != null) {
                this.log.debug("Attempting to delete {} from context {}", (Object)id, (Object)context);
                if (!this.storageService.delete(context, id)) {
                    this.log.info("Failed deleting {} from context {}.", (Object)id, (Object)context);
                }
                ticketCtx = sessionId;
            } else {
                ticketCtx = id;
            }
            this.log.debug("Attempting to delete {} from context {}", (Object)id, (Object)ticketCtx);
            if (!this.storageService.delete(ticketCtx, id)) {
                this.log.info("Failed deleting {} from context {}.", (Object)id, (Object)ticketCtx);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error deleting ticket " + id, e);
        }
        return ticket;
    }

    static {
        CONTEXT_CLASS_MAP.put(ServiceTicket.class, "https://www.apereo.org/cas/protocol/login");
        CONTEXT_CLASS_MAP.put(ProxyTicket.class, "https://www.apereo.org/cas/protocol/proxy");
        CONTEXT_CLASS_MAP.put(ProxyGrantingTicket.class, "https://www.apereo.org/cas/protocol/serviceValidate");
        SERIALIZER_MAP.put(ServiceTicket.class, ST_SERIALIZER);
        SERIALIZER_MAP.put(ProxyTicket.class, PT_SERIALIZER);
        SERIALIZER_MAP.put(ProxyGrantingTicket.class, PGT_SERIALIZER);
    }
}

