/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import net.shibboleth.idp.cas.flow.impl.AbstractFlowActionTest;
import net.shibboleth.idp.cas.flow.impl.CheckProxyAuthorizationAction;
import net.shibboleth.idp.cas.flow.impl.TestContextBuilder;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.service.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CheckProxyAuthorizationActionTest
extends AbstractFlowActionTest {
    @Autowired
    private CheckProxyAuthorizationAction<?, ?> action;

    @Test
    public void testProxyAuthorizationSuccess() throws Exception {
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/login").addServiceContext(new Service("https://serviceA.example.org/", "proxying", true)).build();
        Assert.assertNull((Object)this.action.execute(context));
    }

    @Test
    public void testProxyAuthorizationFailure() throws Exception {
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/login").addServiceContext(new Service("https://serviceB.example.org/", "no-proxy", false)).build();
        Event event = this.action.execute(context);
        assert (event != null);
        Assert.assertEquals((String)event.getId(), (String)ProtocolError.ProxyNotAuthorized.name());
    }
}

