/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import net.shibboleth.idp.cas.flow.impl.AbstractFlowActionTest;
import net.shibboleth.idp.cas.flow.impl.TestContextBuilder;
import net.shibboleth.idp.cas.flow.impl.ValidateRenewAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ValidateRenewActionTest
extends AbstractFlowActionTest {
    private static final String TEST_SERVICE = "https://example.com/widget";
    @Autowired
    private ValidateRenewAction action;

    @Test
    public void testTicketNotFromRenew() throws Exception {
        ServiceTicket ticket = this.createServiceTicket(TEST_SERVICE, true);
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/login").addProtocolContext(new TicketValidationRequest(TEST_SERVICE, ticket.getId()), null).addTicketContext((Ticket)ticket).build();
        Event event = this.action.execute(context);
        assert (event != null);
        Assert.assertEquals((String)event.getId(), (String)ProtocolError.TicketNotFromRenew.name());
    }

    @Test
    public void testRenewIncompatibleWithProxy() throws Exception {
        ServiceTicket st = this.createServiceTicket(TEST_SERVICE, false);
        ProxyGrantingTicket pgt = this.createProxyGrantingTicket(st, "https://example.com/widget/proxy");
        ProxyTicket pt = this.createProxyTicket(pgt, "https://foo.example.org");
        TicketValidationRequest request = new TicketValidationRequest(TEST_SERVICE, pt.getId());
        request.setRenew(true);
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/login").addProtocolContext(request, null).addTicketContext((Ticket)pt).build();
        Event event = this.action.execute(context);
        assert (event != null);
        Assert.assertEquals((String)event.getId(), (String)ProtocolError.RenewIncompatibleWithProxy.name());
    }

    @Test
    public void testSuccessWithRenewAndServiceTicket() throws Exception {
        ServiceTicket ticket = this.createServiceTicket(TEST_SERVICE, true);
        TicketValidationRequest request = new TicketValidationRequest(TEST_SERVICE, ticket.getId());
        request.setRenew(true);
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/login").addProtocolContext(request, null).addTicketContext((Ticket)ticket).build();
        Assert.assertNull((Object)this.action.execute(context));
    }

    @Test
    public void testSuccessWithoutRenewAndProxyTicket() throws Exception {
        ServiceTicket st = this.createServiceTicket(TEST_SERVICE, false);
        ProxyGrantingTicket pgt = this.createProxyGrantingTicket(st, "https://example.com/widget/proxy");
        ProxyTicket pt = this.createProxyTicket(pgt, "https://foo.example.org");
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/login").addProtocolContext(new TicketValidationRequest(TEST_SERVICE, pt.getId()), null).addTicketContext((Ticket)pt).build();
        Assert.assertNull((Object)this.action.execute(context));
    }
}

