/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.time.Instant;
import net.shibboleth.idp.cas.config.ValidateConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractFlowActionTest;
import net.shibboleth.idp.cas.flow.impl.Events;
import net.shibboleth.idp.cas.flow.impl.TestContextBuilder;
import net.shibboleth.idp.cas.flow.impl.ValidateTicketAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ValidateTicketActionTest
extends AbstractFlowActionTest {
    private static final String TEST_SERVICE = "https://example.com/widget";

    @Test
    public void testInvalidTicketFormat() throws Exception {
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/serviceValidate").addProtocolContext(new TicketValidationRequest(TEST_SERVICE, "AB-1234-012346abcdef"), null).addRelyingPartyContext(TEST_SERVICE, true, (ProfileConfiguration)new ValidateConfiguration()).build();
        Event event = ValidateTicketActionTest.newAction(this.ticketService).execute(context);
        assert (event != null);
        Assert.assertEquals((String)event.getId(), (String)ProtocolError.InvalidTicketFormat.name());
    }

    @Test
    public void testServiceMismatch() throws Exception {
        ServiceTicket ticket = this.createServiceTicket(TEST_SERVICE, false);
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/serviceValidate").addProtocolContext(new TicketValidationRequest("mismatch", ticket.getId()), null).addRelyingPartyContext(ticket.getService(), true, (ProfileConfiguration)new ValidateConfiguration()).build();
        Event event = ValidateTicketActionTest.newAction(this.ticketService).execute(context);
        assert (event != null);
        Assert.assertEquals((String)event.getId(), (String)ProtocolError.ServiceMismatch.name());
    }

    @Test
    public void testTicketExpired() throws Exception {
        int ticketTTLMillis = 10;
        Instant now = Instant.now();
        assert (now != null);
        Instant then = now.plusMillis(10L);
        assert (then != null);
        TicketState state = new TicketState("+TkSGIRofZyue/p8F4M7TA==", "omega", now, "Password");
        ServiceTicket ticket = this.ticketService.createServiceTicket(this.generateServiceTicketId(), then, TEST_SERVICE, state, false);
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/serviceValidate").addProtocolContext(new TicketValidationRequest(TEST_SERVICE, ticket.getId()), null).addRelyingPartyContext(ticket.getService(), true, (ProfileConfiguration)new ValidateConfiguration()).build();
        Thread.sleep(15L);
        Event event = ValidateTicketActionTest.newAction(this.ticketService).execute(context);
        assert (event != null);
        Assert.assertEquals((String)event.getId(), (String)ProtocolError.TicketExpired.name());
    }

    @Test
    public void testTicketRetrievalError() throws Exception {
        TicketService throwingTicketService = (TicketService)Mockito.mock(TicketService.class);
        Mockito.when((Object)throwingTicketService.removeServiceTicket((String)ArgumentMatchers.any(String.class))).thenThrow(new Throwable[]{new RuntimeException("Broken")});
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/serviceValidate").addProtocolContext(new TicketValidationRequest(TEST_SERVICE, "ST-12345"), null).addRelyingPartyContext(TEST_SERVICE, true, (ProfileConfiguration)new ValidateConfiguration()).build();
        Event event = ValidateTicketActionTest.newAction(throwingTicketService).execute(context);
        assert (event != null);
        Assert.assertEquals((String)event.getId(), (String)ProtocolError.TicketRetrievalError.name());
    }

    @Test
    public void testServiceTicketValidateSuccess() throws Exception {
        ServiceTicket ticket = this.createServiceTicket(TEST_SERVICE, false);
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/serviceValidate").addProtocolContext(new TicketValidationRequest(TEST_SERVICE, ticket.getId()), null).addRelyingPartyContext(ticket.getService(), true, (ProfileConfiguration)new ValidateConfiguration()).build();
        ValidateTicketAction action = ValidateTicketActionTest.newAction(this.ticketService);
        Event event = action.execute(context);
        assert (event != null);
        Assert.assertEquals((String)event.getId(), (String)Events.ServiceTicketValidated.name());
        Assert.assertNotNull((Object)action.getCASResponse(ValidateTicketActionTest.getProfileContext(context)));
    }

    @Test
    public void testServiceTicketValidateSuccessWithJSessionID() throws Exception {
        ServiceTicket ticket = this.createServiceTicket("https://example.com/widget;jsessionid=abc123", false);
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/serviceValidate").addProtocolContext(new TicketValidationRequest(TEST_SERVICE, ticket.getId()), null).addRelyingPartyContext(ticket.getService(), true, (ProfileConfiguration)new ValidateConfiguration()).build();
        ValidateTicketAction action = ValidateTicketActionTest.newAction(this.ticketService);
        Event event = action.execute(context);
        assert (event != null);
        Assert.assertEquals((String)event.getId(), (String)Events.ServiceTicketValidated.name());
        Assert.assertNotNull((Object)action.getCASResponse(ValidateTicketActionTest.getProfileContext(context)));
    }

    @Test
    public void testProxyTicketValidateSuccess() throws Exception {
        ServiceTicket st = this.createServiceTicket(TEST_SERVICE, false);
        ProxyGrantingTicket pgt = this.createProxyGrantingTicket(st, "https://example.com/widget/proxy");
        ProxyTicket pt = this.createProxyTicket(pgt, "proxyA");
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/serviceValidate").addProtocolContext(new TicketValidationRequest("proxyA", pt.getId()), null).addRelyingPartyContext(pt.getService(), true, (ProfileConfiguration)new ValidateConfiguration()).build();
        ValidateTicketAction action = ValidateTicketActionTest.newAction(this.ticketService);
        Event event = action.execute(context);
        assert (event != null);
        Assert.assertEquals((String)event.getId(), (String)Events.ProxyTicketValidated.name());
        Assert.assertNotNull((Object)action.getCASResponse(ValidateTicketActionTest.getProfileContext(context)));
    }

    private static ValidateTicketAction newAction(TicketService service) {
        assert (service != null);
        ValidateTicketAction action = new ValidateTicketAction(service);
        try {
            action.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new RuntimeException("Initialization error", e);
        }
        return action;
    }
}

