/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service.impl;

import java.time.Duration;
import java.util.Timer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.impl.MetadataServiceRegistry;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.spring.resource.ResourceHelper;
import net.shibboleth.shared.xml.ParserPool;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.impl.ResourceBackedMetadataResolver;
import org.opensaml.saml.metadata.resolver.index.impl.EndpointMetadataIndex;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MetadataServiceRegistryTest {
    private ResourceBackedMetadataResolver metadataResolver;

    @DataProvider(name="parameters")
    public Object[][] parameters() {
        String group = "urn:mace:example.org";
        return new Object[][]{{"https://alpha.example.org/", new Service("https://alpha.example.org/", "urn:mace:example.org", true, true)}, {"https://alpha.example.org/a/b/", new Service("https://alpha.example.org/a/b/", "urn:mace:example.org", true, true)}, {"https://alpha.dev.example.org/", new Service("https://alpha.dev.example.org/", "urn:mace:example.org", true, true)}, {"https://alpha.dev.example.org/#1", new Service("https://alpha.dev.example.org/#1", "urn:mace:example.org", true, true)}, {"https://alpha.dev.example.org", null}, {"https://beta.example.org/", new Service("https://beta.example.org/", "urn:mace:example.org", false)}, {"https://betatest.example.org:8443/a?b=2", new Service("https://betatest.example.org:8443/a?b=2", "urn:mace:example.org", false)}};
    }

    @BeforeSuite
    public void initOpenSAML() throws InitializationException {
        InitializationService.initialize();
    }

    @BeforeClass
    public void setUp() throws Exception {
        net.shibboleth.shared.resource.Resource metadata = ResourceHelper.of((Resource)new ClassPathResource("/metadata/cas-test-metadata.xml"));
        this.metadataResolver = new ResourceBackedMetadataResolver(new Timer(true), metadata);
        ParserPool pool = XMLObjectProviderRegistrySupport.getParserPool();
        assert (pool != null);
        this.metadataResolver.setParserPool(pool);
        Duration fiveHundredSeconds = Duration.ofSeconds(500L);
        assert (fiveHundredSeconds != null);
        this.metadataResolver.setMaxRefreshDelay(fiveHundredSeconds);
        this.metadataResolver.setId("cas");
        this.metadataResolver.setIndexes(CollectionSupport.singleton((Object)new EndpointMetadataIndex((Predicate)new MetadataServiceRegistry.LoginEndpointPredicate())));
        this.metadataResolver.initialize();
    }

    @AfterClass
    public void tearDown() {
        this.metadataResolver.destroy();
    }

    @Test(dataProvider="parameters")
    public void testLookup(@Nonnull String serviceURL, Service expected) throws ComponentInitializationException {
        assert (this.metadataResolver != null);
        PredicateRoleDescriptorResolver wrapper = new PredicateRoleDescriptorResolver((MetadataResolver)this.metadataResolver);
        wrapper.initialize();
        MetadataServiceRegistry registry = new MetadataServiceRegistry((RoleDescriptorResolver)wrapper);
        Service actual = registry.lookup(serviceURL);
        if (expected == null) {
            Assert.assertNull((Object)actual);
        } else {
            assert (actual != null);
            Assert.assertEquals((String)actual.getName(), (String)expected.getName());
            Assert.assertEquals((String)actual.getGroup(), (String)expected.getGroup());
            Assert.assertEquals((boolean)actual.isAuthorizedToProxy(), (boolean)expected.isAuthorizedToProxy());
            Assert.assertEquals((boolean)actual.isSingleLogoutParticipant(), (boolean)expected.isSingleLogoutParticipant());
        }
    }
}

