/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.session.impl;

import java.time.Duration;
import java.time.Instant;
import net.shibboleth.idp.cas.session.impl.CASSPSession;
import net.shibboleth.idp.cas.session.impl.CASSPSessionSerializer;
import net.shibboleth.idp.session.SPSession;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CASSPSessionSerializerTest {
    private final CASSPSessionSerializer serializer;

    CASSPSessionSerializerTest() {
        Duration zero = Duration.ZERO;
        assert (zero != null);
        this.serializer = new CASSPSessionSerializer(zero);
    }

    @Test
    public void testSerializeDeserialize() throws Exception {
        Instant exp = Instant.ofEpochMilli(1410539474000000000L);
        Instant other = Instant.ofEpochMilli(1410532279838046000L);
        assert (exp != null && other != null);
        CASSPSession original = new CASSPSession("https://foo.example.com/shibboleth", other, exp, "ST-1234126-ABC1346DEADBEEF", "https://foo.example.com/callback");
        String serialized = this.serializer.serialize((SPSession)original);
        CASSPSession deserialized = (CASSPSession)this.serializer.deserialize(1L, "context", "key", serialized, Long.valueOf(exp.toEpochMilli()));
        Assert.assertEquals((String)deserialized.getId(), (String)original.getId());
        Assert.assertEquals((Object)deserialized.getCreationInstant(), (Object)original.getCreationInstant());
        Assert.assertEquals((Object)deserialized.getExpirationInstant(), (Object)original.getExpirationInstant());
        Assert.assertEquals((String)deserialized.getTicketId(), (String)original.getTicketId());
        Assert.assertEquals((String)deserialized.getServiceURL(), (String)original.getServiceURL());
    }
}

