/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.impl;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketIdentifierGenerationStrategy;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.cas.ticket.impl.EncodingTicketService;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerKeyStrategy;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.RandomIdentifierParameterSpec;
import net.shibboleth.shared.security.impl.BasicKeystoreKeyStrategy;
import net.shibboleth.shared.spring.resource.ResourceHelper;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.binary.Base32;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class EncodingTicketServiceTest {
    private EncodingTicketService ticketService;
    private IdentifierGenerationStrategy sessionIdGenerator;
    private IdentifierGenerationStrategy pgtIdGenerator;

    @BeforeClass
    public void setUp() throws Exception {
        this.pgtIdGenerator = new TicketIdentifierGenerationStrategy("PGT", 32);
        this.sessionIdGenerator = IdentifierGenerationStrategy.getInstance((IdentifierGenerationStrategy.ProviderType)IdentifierGenerationStrategy.ProviderType.RANDOM, (IdentifierGenerationStrategy.ParameterSpec)new RandomIdentifierParameterSpec(null, Integer.valueOf(32), null));
        BasicKeystoreKeyStrategy strategy = new BasicKeystoreKeyStrategy();
        strategy.setKeystoreResource(ResourceHelper.of((Resource)new ClassPathResource("credentials/sealer.jks")));
        strategy.setKeyVersionResource(ResourceHelper.of((Resource)new ClassPathResource("credentials/sealer.kver")));
        strategy.setKeystorePassword("password");
        strategy.setKeyAlias("secret");
        strategy.setKeyPassword("password");
        strategy.initialize();
        Base32 codec = new Base32(0, null, false, 45);
        DataSealer sealer = new DataSealer();
        sealer.setKeyStrategy((DataSealerKeyStrategy)strategy);
        sealer.setEncoder((BinaryEncoder)codec);
        sealer.setDecoder((BinaryDecoder)codec);
        sealer.initialize();
        this.ticketService = new EncodingTicketService((StorageService)new MemoryStorageService(), sealer);
    }

    @Test
    public void testCreateRemoveServiceTicketSuccess() throws Exception {
        TicketState state = this.newState("aloysius");
        String service = "https://www.example.com/s1/";
        Instant expiry = Instant.now().plusSeconds(5L);
        String id = String.valueOf(System.currentTimeMillis());
        assert (id != null && expiry != null);
        ServiceTicket st1 = this.ticketService.createServiceTicket(id, expiry, "https://www.example.com/s1/", state, true);
        assert (st1 != null);
        Assert.assertTrue((boolean)st1.getId().startsWith("ST-"));
        ServiceTicket st2 = this.ticketService.removeServiceTicket(st1.getId());
        assert (st2 != null);
        Assert.assertEquals((String)st1.getId(), (String)st2.getId());
        Assert.assertEquals((Object)expiry.truncatedTo(ChronoUnit.MILLIS), (Object)st2.getExpirationInstant());
        Assert.assertEquals((String)"https://www.example.com/s1/", (String)st2.getService());
        Assert.assertTrue((boolean)st2.isRenew());
        Assert.assertEquals((String)state.getSessionId(), (String)st2.getSessionId());
        Assert.assertEquals((Object)state, (Object)st2.getTicketState());
        ServiceTicket st3 = this.ticketService.removeServiceTicket(st1.getId());
        assert (st3 != null);
        Assert.assertEquals((String)st1.getId(), (String)st3.getId());
    }

    @Test
    public void testCreateRemoveServiceTicketInvalid() throws Exception {
        Instant expiry = Instant.now().plusSeconds(5L);
        String nowString = String.valueOf(System.currentTimeMillis());
        assert (expiry != null && nowString != null);
        ServiceTicket st1 = this.ticketService.createServiceTicket(nowString, expiry, "https://www.example.com/s2/", this.newState("bartholomew"), true);
        Assert.assertNotNull((Object)st1);
        Assert.assertNull((Object)this.ticketService.removeServiceTicket("ST-abc123"));
    }

    @Test
    public void testCreateServiceTicketSuccessWithLongID() throws Exception {
        TicketState state = this.newState("charlemagne@vt.edu");
        String service = "https://www.google.com/maps/place/Mountain+Lake+Lodge/@37.3554696,-80.539459,17z/data=!3m1!4b1!4m5!3m4!1s0x884dc6a58faa2119:0x17f3cc6a2c82b614!8m2!3d37.3554696!4d-80.537265";
        Instant expiry = Instant.now().plusSeconds(5L);
        String id = String.valueOf(System.currentTimeMillis());
        assert (expiry != null && id != null);
        ServiceTicket st1 = this.ticketService.createServiceTicket(id, expiry, "https://www.google.com/maps/place/Mountain+Lake+Lodge/@37.3554696,-80.539459,17z/data=!3m1!4b1!4m5!3m4!1s0x884dc6a58faa2119:0x17f3cc6a2c82b614!8m2!3d37.3554696!4d-80.537265", state, true);
        Assert.assertNotNull((Object)st1);
        Assert.assertTrue((boolean)st1.getId().matches("ST-[A-Za-z0-9]+-*"));
        Assert.assertTrue((st1.getId().length() < 600 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateRemoveProxyTicketSuccess() throws Exception {
        ProxyGrantingTicket pgt = this.newPGT(this.newState("donegal"), "https://www.example.com/s1/");
        String service = "https://www.example.com/s2/";
        Instant expiry = Instant.now().plusSeconds(5L);
        String id = String.valueOf(System.currentTimeMillis());
        assert (id != null && expiry != null);
        ProxyTicket pt1 = this.ticketService.createProxyTicket(id, expiry, pgt, "https://www.example.com/s2/");
        assert (pt1 != null);
        Assert.assertTrue((boolean)pt1.getId().startsWith("PT-"));
        ProxyTicket pt2 = this.ticketService.removeProxyTicket(pt1.getId());
        assert (pt2 != null);
        Assert.assertEquals((String)pt1.getId(), (String)pt2.getId());
        Assert.assertEquals((Object)expiry.truncatedTo(ChronoUnit.MILLIS), (Object)pt2.getExpirationInstant());
        Assert.assertEquals((String)"https://www.example.com/s2/", (String)pt2.getService());
        Assert.assertEquals((String)pgt.getId(), (String)pt2.getPgtId());
        Assert.assertEquals((Object)pgt.getTicketState(), (Object)pt2.getTicketState());
        ProxyTicket pt3 = this.ticketService.removeProxyTicket(pt1.getId());
        assert (pt3 != null);
        Assert.assertEquals((String)pt1.getId(), (String)pt3.getId());
    }

    @Test
    public void testCreateRemoveProxyTicketInvalid() throws Exception {
        ProxyGrantingTicket pgt = this.newPGT(this.newState("esquire"), "https://www.example.com/s1/");
        String service = "https://www.example.com/s2/";
        Instant expiry = Instant.now().plusSeconds(5L);
        String id = String.valueOf(System.currentTimeMillis());
        assert (id != null && expiry != null && pgt != null);
        ProxyTicket pt1 = this.ticketService.createProxyTicket(id, expiry, pgt, "https://www.example.com/s2/");
        assert (pt1 != null);
        Assert.assertNull((Object)this.ticketService.removeProxyTicket("PT-123"));
    }

    @Test
    public void testCreateFetchRemoveEncodedProxyGrantingTicket() {
        String principal = "aleph";
        String serviceUrl = "https://www.example.com/service1";
        String pgtUrl = "https://www.example.com/pgt1";
        Instant then = Instant.now().plusSeconds(5L);
        String nowString = String.valueOf(System.currentTimeMillis());
        assert (then != null && nowString != null);
        ServiceTicket st = this.ticketService.createServiceTicket(nowString, then, "https://www.example.com/service1", this.newState("aleph"), true);
        Instant expiry = Instant.now().plusSeconds(3600L);
        assert (expiry != null);
        ProxyGrantingTicket pgt = this.ticketService.createProxyGrantingTicket("notused", expiry, st, "https://www.example.com/pgt1");
        Assert.assertTrue((boolean)pgt.getId().startsWith("PGT-E-"));
        ProxyGrantingTicket pgt2 = this.ticketService.fetchProxyGrantingTicket(pgt.getId());
        assert (pgt2 != null);
        Assert.assertEquals((String)pgt2.getService(), (String)"https://www.example.com/service1");
        Assert.assertEquals((String)pgt2.getProxyCallbackUrl(), (String)"https://www.example.com/pgt1");
        TicketState ts2 = pgt2.getTicketState();
        assert (ts2 != null);
        Assert.assertEquals((String)ts2.getPrincipalName(), (String)"aleph");
        ProxyGrantingTicket pgt3 = this.ticketService.removeProxyGrantingTicket(pgt.getId());
        assert (pgt3 != null);
        Assert.assertNotNull((Object)pgt3);
        Assert.assertEquals((String)pgt3.getService(), (String)"https://www.example.com/service1");
        Assert.assertEquals((String)pgt2.getProxyCallbackUrl(), (String)"https://www.example.com/pgt1");
        TicketState ts3 = pgt3.getTicketState();
        assert (ts3 != null);
        Assert.assertEquals((String)ts3.getPrincipalName(), (String)"aleph");
        Assert.assertNotNull((Object)this.ticketService.fetchProxyGrantingTicket(pgt.getId()));
    }

    @Nonnull
    private TicketState newState(@Nonnull String principal) {
        Instant truncatedNow = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        assert (truncatedNow != null);
        return new TicketState(this.sessionIdGenerator.generateIdentifier(), principal, truncatedNow, "authn/Password");
    }

    @Nonnull
    private ProxyGrantingTicket newPGT(@Nonnull TicketState state, @Nonnull String service) {
        Instant then = Instant.now().plusSeconds(300L);
        assert (then != null);
        ProxyGrantingTicket pgt = new ProxyGrantingTicket(this.pgtIdGenerator.generateIdentifier(), service, then, service + "/proxy", "PGT-12345");
        pgt.setTicketState(state);
        return pgt;
    }
}

