/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.serialization.impl;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.cas.ticket.serialization.impl.ProxyTicketSerializer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ProxyTicketSerializerTest {
    private ProxyTicketSerializer serializer = new ProxyTicketSerializer();

    @Test
    public void testSerializeWithoutTicketState() throws Exception {
        ProxyTicket pt1 = new ProxyTicket("ST-0123456789-6027f6e93c11b1f587857ee0e7689c27", "https://nobody.example.org", ProxyTicketSerializerTest.expiry(), "PGT-0123456789-87182857dcbc70f8aa2e0ec87ec3e707");
        String serialized = this.serializer.serialize((Ticket)pt1);
        ProxyTicket pt2 = (ProxyTicket)this.serializer.deserialize(1L, "notused", pt1.getId(), serialized, null);
        Assert.assertEquals((String)pt2.getId(), (String)pt1.getId());
        Assert.assertEquals((String)pt2.getService(), (String)pt1.getService());
        Assert.assertEquals((Object)pt2.getExpirationInstant(), (Object)pt1.getExpirationInstant());
        Assert.assertEquals((String)pt2.getPgtId(), (String)pt1.getPgtId());
        Assert.assertEquals((Object)pt2.getTicketState(), (Object)pt1.getTicketState());
    }

    @Test
    public void testSerializeWithTicketState() throws Exception {
        ProxyTicket pt1 = new ProxyTicket("ST-0123456789-e1e212143527d57053e7a72d75b3ccd6", "https://nobody.example.org", ProxyTicketSerializerTest.expiry(), "PGT-0123456789-c0dddd0f73b9494f7fe0b549e8c28002");
        pt1.setTicketState(new TicketState("idpsess-6ebae421b142adb35a3a6303116c3f", "bob", ProxyTicketSerializerTest.expiry(), "Password"));
        String serialized = this.serializer.serialize((Ticket)pt1);
        ProxyTicket pt2 = (ProxyTicket)this.serializer.deserialize(1L, "notused", pt1.getId(), serialized, null);
        Assert.assertEquals((String)pt2.getId(), (String)pt1.getId());
        Assert.assertEquals((String)pt2.getService(), (String)pt1.getService());
        Assert.assertEquals((Object)pt2.getExpirationInstant(), (Object)pt1.getExpirationInstant());
        Assert.assertEquals((String)pt2.getPgtId(), (String)pt1.getPgtId());
        Assert.assertEquals((Object)pt2.getTicketState(), (Object)pt1.getTicketState());
    }

    @Nonnull
    private static Instant expiry() {
        Instant result = Instant.now().plusSeconds(10L).truncatedTo(ChronoUnit.MILLIS);
        assert (result != null);
        return result;
    }
}

