/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.protocol.ProtocolContext;
import net.shibboleth.idp.cas.protocol.ProxyTicketResponse;
import net.shibboleth.idp.cas.protocol.ServiceTicketResponse;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class TicketLookupFunction
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, ProtocolContext> protocolContextFunction;

    public TicketLookupFunction() {
        this((Function<ProfileRequestContext, ProtocolContext>)new ChildContextLookup(ProtocolContext.class));
    }

    public TicketLookupFunction(@Nonnull Function<ProfileRequestContext, ProtocolContext> protocolLookup) {
        this.protocolContextFunction = (Function)Constraint.isNotNull(protocolLookup, (String)"ProtocolContext lookup cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        String ticket;
        ProtocolContext protocolContext = this.protocolContextFunction.apply(input);
        if (protocolContext == null || protocolContext.getRequest() == null) {
            return null;
        }
        Object request = protocolContext.getRequest();
        Object response = protocolContext.getResponse();
        if (response instanceof ServiceTicketResponse) {
            ServiceTicketResponse resp = (ServiceTicketResponse)response;
            ticket = resp.getTicket();
        } else if (response instanceof ProxyTicketResponse) {
            ProxyTicketResponse resp = (ProxyTicketResponse)response;
            ticket = resp.getPt();
        } else if (request instanceof TicketValidationRequest) {
            TicketValidationRequest req = (TicketValidationRequest)request;
            ticket = req.getTicket();
        } else {
            ticket = null;
        }
        return ticket;
    }
}

