/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.cas.ticket.impl.AbstractTicketService;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataSealer;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class EncodingTicketService
extends AbstractTicketService {
    @Nonnull
    public static final String SERVICE_TICKET_PREFIX = "ST";
    @Nonnull
    public static final String PROXY_TICKET_PREFIX = "PT";
    @Nonnull
    public static final String PROXY_GRANTING_TICKET_PREFIX = "PGT-E";
    @Nonnull
    private static final String NOT_USED = "na";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EncodingTicketService.class);
    @Nonnull
    private final DataSealer dataSealer;
    @Nonnull
    @NotEmpty
    private String serviceTicketPrefix = "ST";
    @Nonnull
    @NotEmpty
    private String proxyTicketPrefix = "PT";
    @Nonnull
    @NotEmpty
    private String proxyGrantingTicketPrefix = "PGT-E";

    public EncodingTicketService(@Nonnull @ParameterName(name="service") StorageService service, @Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        super(service);
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    public void setServiceTicketPrefix(@Nonnull @NotEmpty String prefix) {
        this.serviceTicketPrefix = Constraint.isNotEmpty((String)prefix, (String)"Prefix cannot be null or empty");
    }

    public void setProxyTicketPrefix(@Nonnull @NotEmpty String prefix) {
        this.proxyTicketPrefix = Constraint.isNotEmpty((String)prefix, (String)"Prefix cannot be null or empty");
    }

    public void setProxyGrantingTicketPrefix(@Nonnull @NotEmpty String prefix) {
        this.proxyGrantingTicketPrefix = Constraint.isNotEmpty((String)prefix, (String)"Prefix cannot be null or empty");
    }

    @Nonnull
    public ServiceTicket createServiceTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull String service, @Nullable TicketState state, boolean renew) {
        Constraint.isNotNull((Object)state, (String)"State cannot be null");
        ServiceTicket st = new ServiceTicket((String)Constraint.isNotNull((Object)id, (String)"ID cannot be null"), (String)Constraint.isNotNull((Object)service, (String)"Service cannot be null"), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), renew);
        st.setTicketState(state);
        return this.encode(ServiceTicket.class, st, this.serviceTicketPrefix);
    }

    @Nullable
    public ServiceTicket removeServiceTicket(@Nonnull String id) {
        Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        return this.decode(ServiceTicket.class, id, this.serviceTicketPrefix);
    }

    @Nonnull
    public ProxyTicket createProxyTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull ProxyGrantingTicket pgt, @Nonnull String service) {
        Constraint.isNotNull((Object)pgt, (String)"ProxyGrantingTicket cannot be null");
        ProxyTicket pt = new ProxyTicket(NOT_USED, (String)Constraint.isNotNull((Object)service, (String)"Service cannot be null"), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), pgt.getId());
        pt.setTicketState(pgt.getTicketState());
        return this.encode(ProxyTicket.class, pt, this.proxyTicketPrefix);
    }

    @Nullable
    public ProxyTicket removeProxyTicket(@Nonnull String id) {
        return this.decode(ProxyTicket.class, id, this.proxyTicketPrefix);
    }

    @Override
    @Nonnull
    public ProxyGrantingTicket createProxyGrantingTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull ServiceTicket serviceTicket, @Nonnull String pgtUrl) {
        Constraint.isNotNull((Object)serviceTicket, (String)"ServiceTicket cannot be null");
        ProxyGrantingTicket pgt = new ProxyGrantingTicket(NOT_USED, serviceTicket.getService(), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), (String)Constraint.isNotNull((Object)pgtUrl, (String)"pgtUrl cannot be null"), null);
        pgt.setTicketState(serviceTicket.getTicketState());
        return this.encode(ProxyGrantingTicket.class, pgt, this.proxyGrantingTicketPrefix);
    }

    @Override
    @Nullable
    public ProxyGrantingTicket fetchProxyGrantingTicket(@Nonnull String id) {
        Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        if (id.startsWith(this.proxyGrantingTicketPrefix + "-")) {
            return this.decode(ProxyGrantingTicket.class, id, this.proxyGrantingTicketPrefix);
        }
        return super.fetchProxyGrantingTicket(id);
    }

    @Override
    @Nullable
    public ProxyGrantingTicket removeProxyGrantingTicket(@Nonnull String id) {
        Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        if (id.startsWith(this.proxyGrantingTicketPrefix + "-")) {
            return this.decode(ProxyGrantingTicket.class, id, this.proxyGrantingTicketPrefix);
        }
        return super.removeProxyGrantingTicket(id);
    }

    @Nonnull
    <T extends Ticket> T encode(@Nonnull Class<T> ticketClass, @Nonnull T ticket, @Nonnull String prefix) {
        String opaque;
        try {
            opaque = this.dataSealer.wrap(EncodingTicketService.serializer(ticketClass).serialize(ticket), ticket.getExpirationInstant());
        }
        catch (Exception e) {
            throw new RuntimeException("Ticket encoding failed", e);
        }
        Ticket clone = (Ticket)ticketClass.cast(ticket.clone(prefix + "-" + opaque));
        assert (clone != null);
        return (T)clone;
    }

    @Nullable
    private <T extends Ticket> T decode(@Nonnull Class<T> ticketClass, @Nonnull String id, @Nonnull String prefix) {
        try {
            String subString = id.substring(prefix.length() + 1);
            assert (subString != null);
            String decrypted = this.dataSealer.unwrap(subString);
            return (T)((Ticket)EncodingTicketService.serializer(ticketClass).deserialize(0L, NOT_USED, id, decrypted, Long.valueOf(0L)));
        }
        catch (Exception e) {
            this.log.warn("Ticket decoding failed with error: " + e.getMessage());
            this.log.debug("Ticket decoding failed", (Throwable)e);
            return null;
        }
    }
}

