/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.cas.ticket.impl.AbstractTicketService;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.storage.StorageService;

public class SimpleTicketService
extends AbstractTicketService {
    public SimpleTicketService(@Nonnull @ParameterName(name="service") StorageService service) {
        super(service);
    }

    @Nonnull
    public ServiceTicket createServiceTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull String service, @Nullable TicketState state, boolean renew) {
        Constraint.isNotNull((Object)state, (String)"State cannot be null");
        ServiceTicket st = new ServiceTicket((String)Constraint.isNotNull((Object)id, (String)"ID cannot be null"), (String)Constraint.isNotNull((Object)service, (String)"Service cannot be null"), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), renew);
        st.setTicketState(state);
        this.store(st);
        return st;
    }

    @Nullable
    public ServiceTicket removeServiceTicket(@Nonnull String id) {
        Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        return this.delete(id, ServiceTicket.class);
    }

    @Nonnull
    public ProxyTicket createProxyTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull ProxyGrantingTicket pgt, @Nonnull String service) {
        Constraint.isNotNull((Object)pgt, (String)"ProxyGrantingTicket cannot be null");
        ProxyTicket pt = new ProxyTicket((String)Constraint.isNotNull((Object)id, (String)"ID cannot be null"), (String)Constraint.isNotNull((Object)service, (String)"Service cannot be null"), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), pgt.getId());
        pt.setTicketState(pgt.getTicketState());
        this.store(pt);
        return pt;
    }

    @Nullable
    public ProxyTicket removeProxyTicket(@Nonnull String id) {
        return this.delete(id, ProxyTicket.class);
    }
}

