/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.serialization.impl;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;

public abstract class AbstractTicketSerializer<T extends Ticket>
implements StorageSerializer<T> {
    @Nonnull
    @NotEmpty
    private static final String SERVICE_FIELD = "rp";
    @Nonnull
    @NotEmpty
    private static final String EXPIRATION_FIELD = "exp";
    @Nonnull
    @NotEmpty
    private static final String STATE_FIELD = "ts";
    @Nonnull
    @NotEmpty
    private static final String SESSION_FIELD = "sid";
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_FIELD = "p";
    @Nonnull
    @NotEmpty
    private static final String AUTHN_INSTANT_FIELD = "ai";
    @Nonnull
    @NotEmpty
    private static final String AUTHN_METHOD_FIELD = "am";
    @Nonnull
    @NotEmpty
    private static final String CONSENTED_ATTRS_FIELD = "con";
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger(AbstractTicketSerializer.class);
    @Nonnull
    private final JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(null);
    @Nonnull
    private final JsonReaderFactory readerFactory = Json.createReaderFactory(null);

    public void initialize() throws ComponentInitializationException {
    }

    public boolean isInitialized() {
        return true;
    }

    @Nonnull
    public String serialize(@Nonnull T ticket) throws IOException {
        StringWriter buffer = new StringWriter(200);
        try (JsonGenerator gen = this.generatorFactory.createGenerator((Writer)buffer);){
            TicketState state;
            gen.writeStartObject().write(SERVICE_FIELD, ticket.getService()).write(EXPIRATION_FIELD, ticket.getExpirationInstant().toEpochMilli());
            if (ticket.getTicketState() != null && (state = ticket.getTicketState()) != null) {
                gen.writeStartObject(STATE_FIELD);
                if (state.getSessionId() != null) {
                    gen.write(SESSION_FIELD, state.getSessionId());
                } else {
                    gen.writeNull(SESSION_FIELD);
                }
                gen.write(PRINCIPAL_FIELD, state.getPrincipalName()).write(AUTHN_INSTANT_FIELD, state.getAuthenticationInstant().toEpochMilli()).write(AUTHN_METHOD_FIELD, state.getAuthenticationMethod());
                Set consentedIds = state.getConsentedAttributeIds();
                if (consentedIds != null) {
                    gen.writeStartArray(CONSENTED_ATTRS_FIELD);
                    for (String id : consentedIds) {
                        gen.write(id);
                    }
                    gen.writeEnd();
                }
                gen.writeEnd();
            }
            this.serializeInternal(gen, ticket);
            gen.writeEnd();
        }
        catch (JsonException e) {
            this.logger.error("Exception serializing {}", ticket, (Object)e);
            throw new IOException("Exception serializing ticket", e);
        }
        String result = buffer.toString();
        assert (result != null);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public T deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        try (JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(value));){
            TicketState state;
            JsonObject to = reader.readObject();
            String service = (String)Constraint.isNotNull((Object)to.getString(SERVICE_FIELD), (String)"Service field was not present");
            Instant expiry = Instant.ofEpochMilli(((JsonNumber)Constraint.isNotNull((Object)to.getJsonNumber(EXPIRATION_FIELD), (String)"Expriation Field was not present")).longValueExact());
            assert (expiry != null);
            JsonObject so = to.getJsonObject(STATE_FIELD);
            if (so != null) {
                JsonValue sessionField = (JsonValue)so.get((Object)SESSION_FIELD);
                String sessionId = !JsonValue.NULL.equals(sessionField) ? ((JsonString)sessionField).getString() : null;
                String principalField = (String)Constraint.isNotNull((Object)so.getString(PRINCIPAL_FIELD), (String)"Principal field was not present");
                JsonNumber authnInstantField = (JsonNumber)Constraint.isNotNull((Object)so.getJsonNumber(AUTHN_INSTANT_FIELD), (String)"Authn Instant field was not present");
                Instant authnInstant = Instant.ofEpochMilli(authnInstantField.longValueExact());
                assert (authnInstant != null);
                String authnMethodField = (String)Constraint.isNotNull((Object)so.getString(AUTHN_METHOD_FIELD), (String)"Authn Method field was not present");
                state = new TicketState(sessionId, principalField, authnInstant, authnMethodField);
                JsonValue consent = (JsonValue)so.get((Object)CONSENTED_ATTRS_FIELD);
                if (consent instanceof JsonArray) {
                    HashSet<String> idset = new HashSet<String>();
                    for (JsonValue id : (JsonArray)consent) {
                        if (!(id instanceof JsonString)) continue;
                        idset.add(((JsonString)id).getString());
                    }
                    state.setConsentedAttributeIds(idset);
                }
            } else {
                state = null;
            }
            T ticket = this.createTicket(to, key, service, expiry);
            ticket.setTicketState(state);
            T t = ticket;
            return t;
        }
        catch (JsonException e) {
            this.logger.error("Exception deserializing {}", (Object)value, (Object)e);
            throw new IOException("Exception deserializing ticket", e);
        }
    }

    @Nonnull
    protected abstract T createTicket(@Nonnull JsonObject var1, @Nonnull String var2, @Nonnull String var3, @Nonnull Instant var4);

    protected abstract void serializeInternal(@Nonnull JsonGenerator var1, @Nonnull T var2);
}

