/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldif.LDIFReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLSocketFactory;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.ldaptive.ssl.CredentialConfigFactory;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.TLSSocketFactory;
import org.springframework.core.io.Resource;

public class InMemoryDirectory {
    @Nonnull
    private final InMemoryDirectoryServer directoryServer;

    public InMemoryDirectory(@Nonnull Resource ldif, @Positive int port, @Nonnull Resource keystore) throws LDAPException, IOException {
        Constraint.isNotNull((Object)ldif, (String)"LDIF resource cannot be null");
        InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{"dc=example,dc=org", "ou=system"});
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            String ksPass = "changeit";
            ks.load(keystore.getInputStream(), "changeit".toCharArray());
            TLSSocketFactory socketFactory = new TLSSocketFactory();
            socketFactory.setSslConfig(new SslConfig(CredentialConfigFactory.createKeyStoreCredentialConfig((KeyStore)ks, (String)"changeit")));
            socketFactory.initialize();
            config.setListenerConfigs(new InMemoryListenerConfig[]{InMemoryListenerConfig.createLDAPConfig((String)"default", null, (int)port, (SSLSocketFactory)socketFactory)});
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error reading keystore", e);
        }
        config.addAdditionalBindCredentials("cn=Directory Manager", "password");
        this.directoryServer = new InMemoryDirectoryServer(config);
        this.directoryServer.importFromLDIF(true, new LDIFReader(ldif.getInputStream()));
    }

    public void start() throws LDAPException {
        this.directoryServer.startListening();
    }

    public void stop() {
        this.directoryServer.shutDown(true);
    }
}

