/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test;

import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.PropertySource;
import org.springframework.mock.env.MockPropertySource;

@Order(value=-2147483648)
public class TestEnvironmentApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TestEnvironmentApplicationContextInitializer.class);

    public void initialize(@Nonnull ConfigurableApplicationContext applicationContext) {
        MockPropertySource mock = new MockPropertySource();
        mock.setProperty("idp.home", (Object)"classpath:");
        mock.setProperty("idp.webflows", (Object)"classpath*:/flows");
        mock.setProperty("idp.authn.flows", (Object)"Password");
        applicationContext.getEnvironment().getPropertySources().addFirst((PropertySource)mock);
        this.log.info("Prepending properties '{}'", mock.getSource());
    }
}

