/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows;

import com.unboundid.ldap.sdk.LDAPException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.factory.X509CertificateFactoryBean;
import net.shibboleth.idp.spring.IdPPropertiesApplicationContextInitializer;
import net.shibboleth.idp.test.InMemoryDirectory;
import net.shibboleth.idp.test.PreferFileSystemApplicationContextInitializer;
import net.shibboleth.idp.test.PreferFileSystemContextLoader;
import net.shibboleth.idp.test.TestEnvironmentApplicationContextInitializer;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.Type4UUIDIdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.support.FluentParserContext;
import org.springframework.binding.mapping.Mapper;
import org.springframework.binding.mapping.impl.DefaultMapper;
import org.springframework.binding.mapping.impl.DefaultMapping;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;
import org.springframework.webflow.expression.spel.WebFlowSpringELExpressionParser;
import org.springframework.webflow.test.MockExternalContext;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;

@ContextConfiguration(locations={"/system/conf/global-system.xml", "/system/conf/mvc-beans.xml", "/system/conf/webflow-config.xml", "/test/test-beans.xml", "/test/override-beans.xml"}, initializers={TestEnvironmentApplicationContextInitializer.class, PreferFileSystemApplicationContextInitializer.class, IdPPropertiesApplicationContextInitializer.class}, loader=PreferFileSystemContextLoader.class)
@WebAppConfiguration
public abstract class AbstractFlowTest
extends AbstractTestNGSpringContextTests {
    @Nonnull
    private static final Logger log = LoggerFactory.getLogger(AbstractFlowTest.class);
    @Nonnull
    public static final String LDIF_FILE = "/test/test-ldap.ldif";
    @Nonnull
    public static final String KEYSTORE_FILE = "/test/test-ldap.keystore";
    @Nonnull
    public static final String IDP_ENTITY_ID = "https://idp.example.org";
    @Nonnull
    public static final String SP_ENTITY_ID = "https://sp.example.org";
    @Nonnull
    public static final String SP_ACS_URL = "https://localhost:8443/sp/SAML1/POST/ACS";
    @Nonnull
    public static final String SP_RELAY_STATE = "myRelayState";
    @Nonnull
    public static final String END_STATE_ID = "end";
    @Nonnull
    public static final String END_STATE_OUTPUT_ATTR_EXPR = "flowRequestContext.getConversationScope().get('opensamlProfileRequestContext')";
    @Nonnull
    public static final String END_STATE_OUTPUT_ATTR_NAME = "ProfileRequestContext";
    @Nonnull
    public static final String IP_ADDRESS_AUTHN_MAP_BEAN_NAME = "shibboleth.authn.IPAddress.Mappings";
    @Nonnull
    public static final String IP_ADDRESS_AUTHN_FLOW_ID = "authn/IPAddress";
    @Nonnull
    public static final String SAML1_TRANSFORM_C14N_BEAN_NAME = "c14n/SAML1Transform";
    @Nonnull
    public static final String SAML2_TRANSFORM_C14N_BEAN_NAME = "c14n/SAML2Transform";
    @NonnullAfterInit
    protected InMemoryDirectory directoryServer;
    @Nonnull
    protected MockExternalContext externalContext;
    @Nonnull
    protected FlowExecutor flowExecutor;
    @Nonnull
    protected MockHttpServletRequest request;
    @Nonnull
    protected MockHttpServletResponse response;
    @NonnullAfterInit
    protected static ParserPool parserPool;
    @NonnullAfterInit
    protected static XMLObjectBuilderFactory builderFactory;
    @NonnullAfterInit
    protected static MarshallerFactory marshallerFactory;
    @NonnullAfterInit
    protected static UnmarshallerFactory unmarshallerFactory;
    @Nonnull
    protected IdentifierGenerationStrategy idGenerator = new Type4UUIDIdentifierGenerationStrategy();
    @Qualifier(value="test.idp.Credential")
    @Autowired
    protected Credential idpCredential;
    @Qualifier(value="test.sp.Credential")
    @Autowired
    protected Credential spCredential;
    @Autowired
    @Qualifier(value="test.sp.X509Certificate")
    protected X509CertificateFactoryBean certFactoryBean;

    @AfterMethod
    public void clearThreadLocals() {
        HttpServletRequestResponseContext.clearCurrent();
    }

    @BeforeMethod
    public void initializeFlowExecutor() {
        this.flowExecutor = (FlowExecutor)this.applicationContext.getBean("flowExecutor", FlowExecutor.class);
        Assert.assertNotNull((Object)this.flowExecutor);
    }

    @BeforeMethod
    public void initializeMocks() {
        this.request = new MockHttpServletRequest();
        this.request.addHeader("Authorization", (Object)"Basic amRvZTpjaGFuZ2VpdA==");
        this.response = new MockHttpServletResponse();
        this.externalContext = new MockExternalContext();
        this.externalContext.setNativeRequest((Object)this.request);
        this.externalContext.setNativeResponse((Object)this.response);
    }

    @BeforeMethod
    public void initializeThreadLocals() {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)this.request, (HttpServletResponse)this.response);
    }

    @BeforeClass
    public void initializeXMLObjectSupport() {
        parserPool = XMLObjectProviderRegistrySupport.getParserPool();
        builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
        unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
    }

    @BeforeTest
    public void setupDirectoryServer() throws LDAPException, IOException {
        this.directoryServer = new InMemoryDirectory((Resource)new ClassPathResource(LDIF_FILE), 10389, (Resource)new ClassPathResource(KEYSTORE_FILE));
        this.directoryServer.start();
    }

    @AfterTest(alwaysRun=true)
    public void teardownDirectoryServer() {
        if (this.directoryServer != null) {
            this.directoryServer.stop();
        }
    }

    public void assertFlowExecutionResult(@Nullable FlowExecutionResult result, @Nonnull String flowID) {
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result.getFlowId(), (String)flowID);
        Assert.assertTrue((boolean)result.isEnded());
    }

    public void assertFlowExecutionOutcome(@Nullable FlowExecutionOutcome outcome) {
        this.assertFlowExecutionOutcome(outcome, END_STATE_ID);
    }

    public void assertFlowExecutionOutcome(@Nullable FlowExecutionOutcome outcome, @Nullable String endStateId) {
        Assert.assertNotNull((Object)outcome, (String)"Flow ended with an error");
        Assert.assertEquals((String)outcome.getId(), (String)endStateId);
        Assert.assertTrue((boolean)outcome.getOutput().contains(END_STATE_OUTPUT_ATTR_NAME));
        Assert.assertTrue((boolean)(outcome.getOutput().get(END_STATE_OUTPUT_ATTR_NAME) instanceof ProfileRequestContext));
    }

    public void assertProfileRequestContext(@Nullable ProfileRequestContext profileRequestContext) {
        Assert.assertNotNull((Object)profileRequestContext);
        Assert.assertNotNull((Object)profileRequestContext.getOutboundMessageContext());
        Assert.assertNotNull((Object)profileRequestContext.getOutboundMessageContext().getMessage());
    }

    @Nonnull
    public static Envelope buildSOAP11Envelope(@Nonnull XMLObject payload) {
        Envelope envelope = (Envelope)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME).buildObject(Envelope.DEFAULT_ELEMENT_NAME);
        Body body = (Body)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME).buildObject(Body.DEFAULT_ELEMENT_NAME);
        body.getUnknownXMLObjects().add(payload);
        envelope.setBody(body);
        return envelope;
    }

    @Nonnull
    public Flow getFlow(@Nonnull String flowID) {
        Constraint.isNotNull((Object)flowID, (String)"Flow ID can not be null");
        Constraint.isTrue((boolean)(this.flowExecutor instanceof FlowExecutorImpl), (String)("The flow executor must be an instance of " + FlowExecutorImpl.class));
        FlowDefinition flowDefinition = ((FlowExecutorImpl)this.flowExecutor).getDefinitionLocator().getFlowDefinition(flowID);
        Constraint.isTrue((boolean)(flowDefinition instanceof Flow), (String)("The flow definition must be an instance of " + Flow.class));
        return (Flow)flowDefinition;
    }

    public void overrideEndStateOutput(@Nonnull String flowID) {
        this.overrideEndStateOutput(flowID, END_STATE_ID);
    }

    public void overrideEndStateOutput(@Nonnull String flowID, @Nonnull String endStateId) {
        Flow flow = this.getFlow(flowID);
        WebFlowSpringELExpressionParser parser = new WebFlowSpringELExpressionParser(new SpelExpressionParser());
        Expression source = parser.parseExpression(END_STATE_OUTPUT_ATTR_EXPR, (ParserContext)new FluentParserContext().evaluate(RequestContext.class));
        Expression target = parser.parseExpression(END_STATE_OUTPUT_ATTR_NAME, (ParserContext)new FluentParserContext().evaluate(MutableAttributeMap.class));
        DefaultMapping defaultMapping = new DefaultMapping(source, target);
        DefaultMapper defaultMapper = new DefaultMapper();
        defaultMapper.addMapping(defaultMapping);
        EndState endState = (EndState)flow.getState(endStateId);
        endState.setOutputMapper((Mapper)defaultMapper);
    }

    public void registerFlowsInParentRegistry(@Nonnull String flowID, @Nonnull String childRegistryID) {
        Constraint.isNotNull((Object)flowID, (String)"Flow ID can not be null");
        Constraint.isNotNull((Object)childRegistryID, (String)"Flow registry ID can not be null");
        Flow flow = this.getFlow(flowID);
        FlowDefinitionRegistry flowRegistry = (FlowDefinitionRegistry)flow.getApplicationContext().getBean(childRegistryID, FlowDefinitionRegistry.class);
        Constraint.isNotNull((Object)flowRegistry.getParent(), (String)"Child flow registry must have a parent");
        for (String flowDefinitionId : flowRegistry.getFlowDefinitionIds()) {
            log.debug("Adding flow '{}' from child registry to parent registry", (Object)flowDefinitionId);
            flowRegistry.getParent().registerFlowDefinition(flowRegistry.getFlowDefinition(flowDefinitionId));
        }
    }

    @Nullable
    public ProfileRequestContext retrieveProfileRequestContext(@Nonnull FlowExecutionResult result) {
        Constraint.isNotNull((Object)result, (String)"Result can not be null");
        return (ProfileRequestContext)result.getOutcome().getOutput().get(END_STATE_OUTPUT_ATTR_NAME);
    }
}

