/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.c14n.actions;

import java.security.Principal;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.AttributeEncoder;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.authn.principal.NameIdentifierPrincipal;
import net.shibboleth.idp.saml.nameid.SAML1NameIdentifierAttributeEncoder;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml1.core.NameIdentifier;

public class SetupForSAML1C14N
extends AbstractProfileAction {
    private String attributeName;

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RelyingPartyContext rpc = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class);
        NameIdentifier nid = null;
        AttributeContext ac = (AttributeContext)rpc.getSubcontext(AttributeContext.class, false);
        for (AttributeEncoder enc : ((IdPAttribute)ac.getIdPAttributes().get(this.getAttributeName())).getEncoders()) {
            if (!(enc instanceof SAML1NameIdentifierAttributeEncoder) || !enc.getActivationCondition().apply((Object)profileRequestContext)) continue;
            try {
                nid = (NameIdentifier)((SAML1NameIdentifierAttributeEncoder)enc).encode((IdPAttribute)ac.getIdPAttributes().get(this.getAttributeName()));
            }
            catch (AttributeEncodingException e) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return;
            }
        }
        if (nid == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        NameIdentifierPrincipal nidp = new NameIdentifierPrincipal(nid);
        Subject sub = new Subject();
        sub.getPrincipals().add((Principal)nidp);
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)profileRequestContext.getSubcontext(SubjectCanonicalizationContext.class, true);
        scc.setSubject(sub);
        scc.setRequesterId(rpc.getRelyingPartyId());
        scc.setResponderId(rpc.getConfiguration().getResponderId());
    }
}

