/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.c14n.actions;

import java.security.Principal;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.AttributeEncoder;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.idp.saml.nameid.SAML2NameIDAttributeEncoder;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.NameID;

public class SetupForSAML2C14N
extends AbstractProfileAction {
    private String attributeName;

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RelyingPartyContext rpc = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class);
        NameID nid = null;
        AttributeContext ac = (AttributeContext)rpc.getSubcontext(AttributeContext.class, false);
        for (AttributeEncoder enc : ((IdPAttribute)ac.getIdPAttributes().get(this.getAttributeName())).getEncoders()) {
            if (!(enc instanceof SAML2NameIDAttributeEncoder) || !enc.getActivationCondition().apply((Object)profileRequestContext)) continue;
            try {
                nid = (NameID)((SAML2NameIDAttributeEncoder)enc).encode((IdPAttribute)ac.getIdPAttributes().get(this.getAttributeName()));
            }
            catch (AttributeEncodingException e) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return;
            }
        }
        if (nid == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        NameIDPrincipal nidp = new NameIDPrincipal(nid);
        Subject sub = new Subject();
        sub.getPrincipals().add((Principal)nidp);
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)profileRequestContext.getSubcontext(SubjectCanonicalizationContext.class, true);
        scc.setSubject(sub);
        scc.setRequesterId(rpc.getRelyingPartyId());
        scc.setResponderId(rpc.getConfiguration().getResponderId());
    }
}

