/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.cas;

import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.idp.session.impl.StorageBackedSessionManager;
import net.shibboleth.idp.test.flows.AbstractFlowTest;
import net.shibboleth.utilities.java.support.net.URISupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@ContextConfiguration(locations={"/test/test-cas-beans.xml"})
public class LoginFlowInitialAuthnTest
extends AbstractFlowTest {
    @Nonnull
    private static String FLOW_ID = "cas/login";
    @Autowired
    private StorageBackedSessionManager sessionManager;
    @Autowired
    @Qualifier(value="shibboleth.CASTicketService")
    private TicketService ticketService;

    @BeforeClass
    public void enableInitialAuthn() {
        System.setProperty("idp.authn.flows.initial", "Password");
    }

    @AfterClass
    public void disableInitialAuthn() {
        System.setProperty("idp.authn.flows.initial", "");
    }

    @Test
    public void testLoginStartSession() throws Exception {
        String service = "https://start.example.org/";
        this.externalContext.getMockRequestParameterMap().put("service", "https://start.example.org/");
        this.overrideEndStateOutput(FLOW_ID, "RedirectToService");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"RedirectToService");
        String url = this.externalContext.getExternalRedirectUrl();
        Assert.assertTrue((boolean)url.contains("ticket=ST-"));
        String ticketId = URISupport.doURLDecode((String)url.substring(url.indexOf("ticket=") + 7));
        ServiceTicket st = this.ticketService.removeServiceTicket(ticketId);
        Assert.assertNotNull((Object)st);
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(st.getSessionId())}));
        Assert.assertNotNull((Object)session);
        ProfileRequestContext prc = (ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext");
        Assert.assertNotNull((Object)prc.getSubcontext(SubjectContext.class));
    }
}

