/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.cas;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.servlet.http.Cookie;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.cas.config.impl.LoginConfiguration;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.idp.consent.context.impl.ConsentContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.idp.session.impl.StorageBackedSessionManager;
import net.shibboleth.idp.test.flows.AbstractFlowTest;
import net.shibboleth.utilities.java.support.net.URISupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@ContextConfiguration(locations={"/test/test-cas-beans.xml"})
public class LoginFlowTest
extends AbstractFlowTest {
    @Nonnull
    private static String FLOW_ID = "cas/login";
    @Autowired
    @Qualifier(value="shibboleth.CASTicketService")
    private TicketService ticketService;
    @Autowired
    private StorageBackedSessionManager sessionManager;
    @Autowired
    @Qualifier(value="shibboleth.RelyingPartyConfigurationResolver")
    private RelyingPartyConfigurationResolver relyingPartyConfigurationResolver;

    @BeforeMethod
    public void setUp() throws Exception {
        this.setPostAuthenticationFlows(Collections.emptyList());
    }

    @Test
    public void testGatewayNoSession() throws Exception {
        String service = "https://gateway.example.org/";
        this.externalContext.getMockRequestParameterMap().put("service", "https://gateway.example.org/");
        this.externalContext.getMockRequestParameterMap().put("gateway", "true");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"RedirectToService");
        Assert.assertEquals((String)this.externalContext.getExternalRedirectUrl(), (String)"https://gateway.example.org/");
    }

    @Test
    public void testGatewayWithSession() throws Exception {
        String service = "https://gateway.example.org/";
        IdPSession existing = this.sessionManager.createSession("aurora");
        existing.addAuthenticationResult(new AuthenticationResult("authn/Password", (Principal)new UsernamePrincipal("aurora")));
        this.externalContext.getMockRequestParameterMap().put("service", "https://gateway.example.org/");
        this.externalContext.getMockRequestParameterMap().put("gateway", "true");
        this.overrideEndStateOutput(FLOW_ID, "RedirectToService");
        this.request.setCookies(new Cookie[]{new Cookie("shib_idp_session", existing.getId())});
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"RedirectToService");
        String url = this.externalContext.getExternalRedirectUrl();
        Assert.assertTrue((boolean)url.contains("https://gateway.example.org/?ticket=ST-"));
    }

    @Test
    public void testLoginStartSession() throws Exception {
        String service = "https://start.example.org/";
        this.externalContext.getMockRequestParameterMap().put("service", "https://start.example.org/");
        this.overrideEndStateOutput(FLOW_ID, "RedirectToService");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"RedirectToService");
        String ticketId = this.getTicketIdFromUrl(this.externalContext.getExternalRedirectUrl());
        ServiceTicket st = this.ticketService.removeServiceTicket(ticketId);
        Assert.assertNotNull((Object)st);
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(st.getSessionId())}));
        Assert.assertNotNull((Object)session);
        ProfileRequestContext prc = (ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext");
        Assert.assertNotNull((Object)prc.getSubcontext(SubjectContext.class));
        this.assertPopulatedAttributeContext(prc);
    }

    @Test
    public void testLoginStartSessionWithPostMethod() throws Exception {
        String service = "https://start.example.org/";
        this.externalContext.getMockRequestParameterMap().put("service", "https://start.example.org/");
        this.externalContext.getMockRequestParameterMap().put("method", "post");
        this.overrideEndStateOutput(FLOW_ID, "PostBackToService");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"PostBackToService");
        MockHttpServletResponse mockResponse = (MockHttpServletResponse)this.externalContext.getNativeResponse();
        String body = mockResponse.getContentAsString();
        Assert.assertTrue((boolean)body.contains(String.format("<form action=\"%s\" method=\"post\">", "https://start.example.org/")));
        Assert.assertTrue((boolean)body.contains("<input type=\"hidden\" name=\"ticket\" value=\"ST-"));
        Matcher matcher = Pattern.compile("value=\"([^\"]+)").matcher(body);
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((int)1, (int)matcher.groupCount());
        String ticketId = matcher.group(1);
        ServiceTicket st = this.ticketService.removeServiceTicket(ticketId);
        Assert.assertNotNull((Object)st);
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(st.getSessionId())}));
        Assert.assertNotNull((Object)session);
        ProfileRequestContext prc = (ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext");
        Assert.assertNotNull((Object)prc.getSubcontext(SubjectContext.class));
        this.assertPopulatedAttributeContext(prc);
    }

    @Test
    public void testLoginWithConsent() throws Exception {
        String service = "https://start.example.org/";
        this.externalContext.getMockRequestParameterMap().put("service", "https://start.example.org/");
        this.setPostAuthenticationFlows(Collections.singletonList("attribute-release"));
        this.overrideEndStateOutput(FLOW_ID, "RedirectToService");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"RedirectToService");
        String ticketId = this.getTicketIdFromUrl(this.externalContext.getExternalRedirectUrl());
        ServiceTicket st = this.ticketService.removeServiceTicket(ticketId);
        Assert.assertNotNull((Object)st);
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(st.getSessionId())}));
        Assert.assertNotNull((Object)session);
        ProfileRequestContext prc = (ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext");
        Assert.assertNotNull((Object)prc);
        Assert.assertNotNull((Object)prc.getSubcontext(SubjectContext.class));
        Assert.assertNotNull((Object)prc.getSubcontext(ConsentContext.class, false));
    }

    @Test
    public void testLoginExistingSession() throws Exception {
        String service = "https://existing.example.org/";
        IdPSession existing = this.sessionManager.createSession("aurora");
        existing.addAuthenticationResult(new AuthenticationResult("authn/Password", (Principal)new UsernamePrincipal("aurora")));
        this.externalContext.getMockRequestParameterMap().put("service", "https://existing.example.org/");
        this.overrideEndStateOutput(FLOW_ID, "RedirectToService");
        this.request.setCookies(new Cookie[]{new Cookie("shib_idp_session", existing.getId())});
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"RedirectToService");
        String ticketId = this.getTicketIdFromUrl(this.externalContext.getExternalRedirectUrl());
        ServiceTicket st = this.ticketService.removeServiceTicket(ticketId);
        Assert.assertNotNull((Object)st);
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(st.getSessionId())}));
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((String)session.getId(), (String)existing.getId());
        ProfileRequestContext prc = (ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext");
        Assert.assertNotNull((Object)prc.getSubcontext(SubjectContext.class));
        this.assertPopulatedAttributeContext(prc);
    }

    @Test
    public void testLoginExistingSessionDoNotCache() throws Exception {
        String service = "https://existing.example.org/";
        IdPSession existing = this.sessionManager.createSession("maleficent");
        this.externalContext.getMockRequestParameterMap().put("service", "https://existing.example.org/");
        this.overrideEndStateOutput(FLOW_ID, "RedirectToService");
        this.request.setCookies(new Cookie[]{new Cookie("shib_idp_session", existing.getId())});
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"RedirectToService");
        String ticketId = this.getTicketIdFromUrl(this.externalContext.getExternalRedirectUrl());
        ServiceTicket st = this.ticketService.removeServiceTicket(ticketId);
        Assert.assertNotNull((Object)st);
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(st.getSessionId())}));
        Assert.assertNotNull((Object)session);
        Assert.assertNotEquals((Object)session.getId(), (Object)existing.getId());
        ProfileRequestContext prc = (ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext");
        Assert.assertNotNull((Object)prc.getSubcontext(SubjectContext.class));
        this.assertPopulatedAttributeContext(prc);
    }

    @Test
    public void testErrorNoService() throws Exception {
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"AuditedErrorView");
        Assert.assertTrue((boolean)responseBody.contains("ServiceNotSpecified"));
    }

    private void setPostAuthenticationFlows(List<String> flowIdentifiers) throws Exception {
        ProfileRequestContext prc = new ProfileRequestContext();
        prc.setProfileId("https://www.apereo.org/cas/protocol/login");
        RelyingPartyConfiguration rpConfig = (RelyingPartyConfiguration)this.relyingPartyConfigurationResolver.resolveSingle((Object)prc);
        if (rpConfig == null) {
            throw new IllegalStateException("Relying party configuration not found");
        }
        LoginConfiguration loginConfiguration = (LoginConfiguration)rpConfig.getProfileConfiguration("https://www.apereo.org/cas/protocol/login");
        if (loginConfiguration == null) {
            throw new IllegalStateException("CAS login profile configuration not found");
        }
        loginConfiguration.setPostAuthenticationFlows(flowIdentifiers);
    }

    private void assertPopulatedAttributeContext(ProfileRequestContext prc) {
        Assert.assertNotNull((Object)prc);
        RelyingPartyContext rpc = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class, false);
        Assert.assertNotNull((Object)rpc);
        AttributeContext ac = (AttributeContext)rpc.getSubcontext(AttributeContext.class, false);
        Assert.assertNotNull((Object)ac);
        Assert.assertFalse((boolean)ac.getUnfilteredIdPAttributes().isEmpty());
    }

    private String getTicketIdFromUrl(String url) {
        Assert.assertTrue((boolean)url.contains("ticket=ST-"));
        String ticketId = url.substring(url.indexOf("ticket=") + 7);
        Assert.assertEquals((int)ticketId.indexOf(47), (int)-1);
        Assert.assertEquals((int)ticketId.indexOf(43), (int)-1);
        return URISupport.doURLDecode((String)ticketId);
    }
}

