/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.cas;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketServiceEx;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.cas.ticket.impl.TicketIdentifierGenerationStrategy;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.test.flows.AbstractFlowTest;
import net.shibboleth.idp.test.flows.cas.ToggleablePredicate;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@ContextConfiguration(locations={"/test/test-cas-beans.xml"})
public class ProxyFlowTest
extends AbstractFlowTest {
    @Nonnull
    private static String FLOW_ID = "cas/proxy";
    @Autowired
    @Qualifier(value="shibboleth.CASTicketService")
    private TicketServiceEx ticketService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    @Qualifier(value="shibboleth.CASProxyValidateIdPSessionPredicate")
    private ToggleablePredicate validateIdPSessionPredicate;

    @BeforeMethod
    public void disableIdPSessionValidation() {
        this.validateIdPSessionPredicate.setResult(false);
    }

    @Test
    public void testInvalidRequestNoTicket() throws Exception {
        this.externalContext.getMockRequestParameterMap().put("targetService", "https://test.example.org/");
        this.overrideEndStateOutput(FLOW_ID, "ProtocolErrorView");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"ProtocolErrorView");
        Assert.assertTrue((boolean)responseBody.contains("<cas:proxyFailure code=\"INVALID_REQUEST\">"));
        Assert.assertTrue((boolean)responseBody.contains("E_TICKET_NOT_SPECIFIED"));
    }

    @Test
    public void testInvalidRequestNoService() throws Exception {
        this.externalContext.getMockRequestParameterMap().put("pgt", "PGT-123-ABC");
        this.overrideEndStateOutput(FLOW_ID, "ProtocolErrorView");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"ProtocolErrorView");
        Assert.assertTrue((boolean)responseBody.contains("<cas:proxyFailure code=\"INVALID_REQUEST\">"));
        Assert.assertTrue((boolean)responseBody.contains("E_SERVICE_NOT_SPECIFIED"));
    }

    @Test
    public void testSuccess() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ProxyGrantingTicket ticket = this.createProxyGrantingTicket(session.getId(), "john");
        this.externalContext.getMockRequestParameterMap().put("targetService", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("pgt", ticket.getId());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ProxySuccess");
        Assert.assertTrue((boolean)responseBody.contains("<cas:proxySuccess>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:proxyTicket>PT-"));
    }

    @Test
    public void testSuccessWithIdPSessionValidation() throws Exception {
        this.validateIdPSessionPredicate.setResult(true);
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ProxyGrantingTicket ticket = this.createProxyGrantingTicket(session.getId(), "john");
        this.externalContext.getMockRequestParameterMap().put("targetService", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("pgt", ticket.getId());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ProxySuccess");
        Assert.assertTrue((boolean)responseBody.contains("<cas:proxySuccess>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:proxyTicket>PT-"));
    }

    @Test
    public void testFailureTicketExpired() throws Exception {
        this.externalContext.getMockRequestParameterMap().put("targetService", "https://test.example.org/");
        this.externalContext.getMockRequestParameterMap().put("pgt", "PGT-123-ABC");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ProtocolErrorView");
        String responseBody = this.response.getContentAsString();
        Assert.assertTrue((boolean)responseBody.contains("<cas:proxyFailure code=\"INVALID_TICKET\""));
        Assert.assertTrue((boolean)responseBody.contains("E_TICKET_EXPIRED"));
    }

    @Test
    public void testFailureSessionExpired() throws Exception {
        this.validateIdPSessionPredicate.setResult(true);
        ProxyGrantingTicket ticket = this.createProxyGrantingTicket("No-Such-SessionId", "nobody");
        this.externalContext.getMockRequestParameterMap().put("targetService", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("pgt", ticket.getId());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ProtocolErrorView");
        String responseBody = this.response.getContentAsString();
        Assert.assertTrue((boolean)responseBody.contains("<cas:proxyFailure code=\"INVALID_TICKET\""));
        Assert.assertTrue((boolean)responseBody.contains("E_SESSION_EXPIRED"));
    }

    private ProxyGrantingTicket createProxyGrantingTicket(String sessionId, String principal) {
        ServiceTicket st = this.ticketService.createServiceTicket(new TicketIdentifierGenerationStrategy("ST", 25).generateIdentifier(), DateTime.now().plusSeconds(10).toInstant(), "https://service.example.org/", new TicketState(sessionId, principal, Instant.now(), "Password"), false);
        return this.ticketService.createProxyGrantingTicket(new TicketIdentifierGenerationStrategy("PGT", 50).generateIdentifier(), DateTime.now().plusHours(1).toInstant(), st);
    }
}

