/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.cas;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketServiceEx;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.cas.ticket.impl.TicketIdentifierGenerationStrategy;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.test.flows.AbstractFlowTest;
import net.shibboleth.idp.test.flows.cas.TestProxyAuthenticator;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.Test;

@ContextConfiguration(locations={"/test/test-cas-beans.xml"})
public class ProxyValidateFlowTest
extends AbstractFlowTest {
    @Nonnull
    private static String FLOW_ID = "cas/proxyValidate";
    @Autowired
    @Qualifier(value="shibboleth.CASTicketService")
    private TicketServiceEx ticketService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private TestProxyAuthenticator testProxyAuthenticator;

    @Test
    public void testSuccess() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ProxyTicket ticket = this.createProxyTicket(session.getId(), "john");
        this.externalContext.getMockRequestParameterMap().put("service", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("ticket", ticket.getId());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ValidateSuccess");
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationSuccess>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:user>john</cas:user>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:proxyGrantingTicket>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:proxy>https://service.example.org/</cas:proxy>"));
    }

    @Test
    public void testFailureTicketExpired() throws Exception {
        this.externalContext.getMockRequestParameterMap().put("service", "https://test.example.org/");
        this.externalContext.getMockRequestParameterMap().put("ticket", "PT-123-ABC");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ProtocolErrorView");
        String responseBody = this.response.getContentAsString();
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationFailure code=\"INVALID_TICKET\""));
        Assert.assertTrue((boolean)responseBody.contains("E_TICKET_EXPIRED"));
    }

    @Test
    public void testSuccessWithProxy() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ProxyTicket ticket = this.createProxyTicket(session.getId(), "john");
        this.externalContext.getMockRequestParameterMap().put("service", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("ticket", ticket.getId());
        this.externalContext.getMockRequestParameterMap().put("pgtUrl", "https://proxy.example.com/");
        this.testProxyAuthenticator.setFailureFlag(false);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ValidateSuccess");
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationSuccess>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:user>john</cas:user>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:proxyGrantingTicket>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:proxy>https://service.example.org/</cas:proxy>"));
    }

    @Test(dependsOnMethods={"testSuccessWithProxy"})
    public void testProxyCallbackAuthnFailure() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ProxyTicket ticket = this.createProxyTicket(session.getId(), "john");
        this.externalContext.getMockRequestParameterMap().put("service", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("ticket", ticket.getId());
        this.externalContext.getMockRequestParameterMap().put("pgtUrl", "https://proxy.example.com/");
        this.testProxyAuthenticator.setFailureFlag(true);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ProtocolErrorView");
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationFailure code=\"INVALID_REQUEST\""));
        Assert.assertTrue((boolean)responseBody.contains("E_PROXY_CALLBACK_AUTH_FAILURE"));
    }

    @Test
    public void testFailureBrokenProxyChain() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ProxyTicket ticket = this.createProxyTicket(session.getId(), "john");
        this.ticketService.removeProxyGrantingTicket(ticket.getPgtId());
        this.externalContext.getMockRequestParameterMap().put("service", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("ticket", ticket.getId());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ProtocolErrorView");
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationFailure code=\"INVALID_TICKET\""));
        Assert.assertTrue((boolean)responseBody.contains("E_BROKEN_PROXY_CHAIN"));
    }

    private ProxyTicket createProxyTicket(String sessionId, String principal) {
        ServiceTicket st = this.ticketService.createServiceTicket(new TicketIdentifierGenerationStrategy("ST", 25).generateIdentifier(), DateTime.now().plusSeconds(5).toInstant(), "https://service.example.org/", new TicketState(sessionId, principal, Instant.now(), "Password"), false);
        ProxyGrantingTicket pgt = this.ticketService.createProxyGrantingTicket(new TicketIdentifierGenerationStrategy("PGT", 50).generateIdentifier(), DateTime.now().plusSeconds(10).toInstant(), st);
        return this.ticketService.createProxyTicket(new TicketIdentifierGenerationStrategy("PT", 25).generateIdentifier(), DateTime.now().plusSeconds(5).toInstant(), pgt, "https://proxyA.example.org/");
    }
}

