/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.cas;

import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketServiceEx;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.test.flows.AbstractFlowTest;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.Test;

@ContextConfiguration(locations={"/test/test-cas-beans.xml"})
public class SamlValidateFlowTest
extends AbstractFlowTest {
    @Nonnull
    private static String FLOW_ID = "cas/samlValidate";
    private static final String SAML_REQUEST_TEMPLATE = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body><samlp:Request xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\" MajorVersion=\"1\" MinorVersion=\"1\" RequestID=\"_192.168.16.51.1024506224022\" IssueInstant=\"2002-06-19T17:03:44.022Z\"><samlp:AssertionArtifact>@@TICKET@@</samlp:AssertionArtifact></samlp:Request></SOAP-ENV:Body></SOAP-ENV:Envelope>";
    @Autowired
    @Qualifier(value="shibboleth.CASTicketService")
    private TicketServiceEx ticketService;
    @Autowired
    private SessionManager sessionManager;

    @Test
    public void testSuccess() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ServiceTicket ticket = this.ticketService.createServiceTicket("ST-1415133132-ompog68ygxKyX9BPwPuw0hESQBjuA", DateTime.now().plusSeconds(5).toInstant(), "https://test.example.org/", new TicketState(session.getId(), "john", Instant.now(), "Password"), false);
        String requestBody = SAML_REQUEST_TEMPLATE.replace("@@TICKET@@", ticket.getId());
        this.request.setMethod("POST");
        this.request.setContentType("text/xml");
        this.request.setContent(requestBody.getBytes("UTF-8"));
        this.externalContext.getMockRequestParameterMap().put("TARGET", ticket.getService());
        this.overrideEndStateOutput(FLOW_ID, "ValidateSuccess");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"ValidateSuccess");
        Assert.assertTrue((boolean)responseBody.contains("<saml1p:StatusCode Value=\"saml1p:Success\"/>"));
        Assert.assertTrue((boolean)responseBody.contains("<saml1:NameIdentifier>john</saml1:NameIdentifier>"));
        Assert.assertTrue((boolean)responseBody.contains("<saml1:NameIdentifier>john</saml1:NameIdentifier>"));
        Assert.assertTrue((boolean)responseBody.contains("<saml1:Attribute AttributeName=\"uid\" AttributeNamespace=\"http://www.ja-sig.org/products/cas/\"><saml1:AttributeValue xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xsd:string\">john</saml1:AttributeValue></saml1:Attribute>"));
        Assert.assertTrue((boolean)responseBody.contains("<saml1:Attribute AttributeName=\"mail\" AttributeNamespace=\"http://www.ja-sig.org/products/cas/\"><saml1:AttributeValue xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xsd:string\">john@example.org</saml1:AttributeValue></saml1:Attribute>"));
        Assert.assertTrue((boolean)responseBody.contains("<saml1:Attribute AttributeName=\"eduPersonPrincipalName\" AttributeNamespace=\"http://www.ja-sig.org/products/cas/\"><saml1:AttributeValue xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xsd:string\">john</saml1:AttributeValue></saml1:Attribute>"));
        this.assertPopulatedAttributeContext((ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext"));
    }

    @Test
    public void testFailureTicketExpired() throws Exception {
        String requestBody = SAML_REQUEST_TEMPLATE.replace("@@TICKET@@", "ST-123-abcdefg");
        this.request.setMethod("POST");
        this.request.setContentType("text/xml");
        this.request.setContent(requestBody.getBytes("UTF-8"));
        this.externalContext.getMockRequestParameterMap().put("TARGET", "https://test.example.org/");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ProtocolErrorView");
        String responseBody = this.response.getContentAsString();
        Assert.assertTrue((boolean)responseBody.contains("<saml1p:StatusCode Value=\"INVALID_TICKET\""));
        Assert.assertTrue((boolean)responseBody.contains("<saml1p:StatusMessage>E_TICKET_EXPIRED</saml1p:StatusMessage>"));
    }

    @Test
    public void testSuccessWhenResolveAttributesFalse() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ServiceTicket ticket = this.ticketService.createServiceTicket("ST-2718281828-ompog68ygxKyX9BPwPuw0hESQBjuA", DateTime.now().plusSeconds(5).toInstant(), "https://no-attrs.example.org/", new TicketState(session.getId(), "john", Instant.now(), "Password"), false);
        String requestBody = SAML_REQUEST_TEMPLATE.replace("@@TICKET@@", ticket.getId());
        this.request.setMethod("POST");
        this.request.setContentType("text/xml");
        this.request.setContent(requestBody.getBytes("UTF-8"));
        this.externalContext.getMockRequestParameterMap().put("TARGET", ticket.getService());
        this.overrideEndStateOutput(FLOW_ID, "ValidateSuccess");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"ValidateSuccess");
        Assert.assertTrue((boolean)responseBody.contains("<saml1p:StatusCode Value=\"saml1p:Success\"/>"));
        Assert.assertTrue((boolean)responseBody.contains("<saml1:NameIdentifier>john</saml1:NameIdentifier>"));
        Assert.assertTrue((boolean)responseBody.contains("<saml1:NameIdentifier>john</saml1:NameIdentifier>"));
        Assert.assertTrue((boolean)responseBody.contains("<saml1:Attribute AttributeName=\"uid\" AttributeNamespace=\"http://www.ja-sig.org/products/cas/\"><saml1:AttributeValue xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xsd:string\">john</saml1:AttributeValue></saml1:Attribute>"));
        Assert.assertTrue((boolean)responseBody.contains("<saml1:Attribute AttributeName=\"mail\" AttributeNamespace=\"http://www.ja-sig.org/products/cas/\"><saml1:AttributeValue xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xsd:string\">john@example.org</saml1:AttributeValue></saml1:Attribute>"));
        Assert.assertTrue((boolean)responseBody.contains("<saml1:Attribute AttributeName=\"eduPersonPrincipalName\" AttributeNamespace=\"http://www.ja-sig.org/products/cas/\"><saml1:AttributeValue xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xsd:string\">john</saml1:AttributeValue></saml1:Attribute>"));
        this.assertPopulatedAttributeContext((ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext"));
    }

    private void assertPopulatedAttributeContext(ProfileRequestContext prc) {
        Assert.assertNotNull((Object)prc);
        RelyingPartyContext rpc = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class, false);
        Assert.assertNotNull((Object)rpc);
        AttributeContext ac = (AttributeContext)rpc.getSubcontext(AttributeContext.class, false);
        Assert.assertNotNull((Object)ac);
        Assert.assertFalse((boolean)ac.getUnfilteredIdPAttributes().isEmpty());
    }
}

