/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.cas;

import java.net.URI;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.cas.proxy.ProxyAuthenticator;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketServiceEx;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.idp.test.flows.AbstractFlowTest;
import net.shibboleth.idp.test.flows.cas.TestProxyAuthenticator;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.Test;

@ContextConfiguration(locations={"/test/test-cas-beans.xml"})
public class ServiceValidateFlowTest
extends AbstractFlowTest {
    @Nonnull
    private static String FLOW_ID = "cas/serviceValidate";
    @Autowired
    @Qualifier(value="shibboleth.CASTicketService")
    private TicketServiceEx ticketService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SessionResolver sessionResolver;
    @Autowired
    private TestProxyAuthenticator testProxyAuthenticator;

    @Test
    public void testInvalidRequestNoTicket() throws Exception {
        this.externalContext.getMockRequestParameterMap().put("service", "https://test.example.org/");
        this.overrideEndStateOutput(FLOW_ID, "ProtocolErrorView");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"ProtocolErrorView");
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationFailure code=\"INVALID_REQUEST\">"));
        Assert.assertTrue((boolean)responseBody.contains("E_TICKET_NOT_SPECIFIED"));
    }

    @Test
    public void testInvalidRequestNoService() throws Exception {
        this.externalContext.getMockRequestParameterMap().put("ticket", "ST-123-ABC");
        this.overrideEndStateOutput(FLOW_ID, "ProtocolErrorView");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"ProtocolErrorView");
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationFailure code=\"INVALID_REQUEST\">"));
        Assert.assertTrue((boolean)responseBody.contains("E_SERVICE_NOT_SPECIFIED"));
    }

    @Test
    public void testSuccess() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ServiceTicket ticket = this.ticketService.createServiceTicket("ST-1415133132-ompog68ygxKyX9BPwPuw0hESQBjuA", DateTime.now().plusSeconds(5).toInstant(), "https://test.example.org/", new TicketState(session.getId(), "john", Instant.now(), "Password"), false);
        this.externalContext.getMockRequestParameterMap().put("service", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("ticket", ticket.getId());
        this.overrideEndStateOutput(FLOW_ID, "ValidateSuccess");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"ValidateSuccess");
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationSuccess>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:user>john</cas:user>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:attributes>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:uid>john</cas:uid>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:eduPersonPrincipalName>john</cas:eduPersonPrincipalName>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:mail>john@example.org</cas:mail>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:proxyGrantingTicket>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:proxies>"));
        this.assertPopulatedAttributeContext((ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext"));
        IdPSession updatedSession = (IdPSession)this.sessionResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new SessionIdCriterion(session.getId())}));
        Assert.assertNotNull((Object)updatedSession);
        Assert.assertEquals((int)updatedSession.getSPSessions().size(), (int)0);
    }

    @Test
    public void testSuccessWithSLOParticipant() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ServiceTicket ticket = this.ticketService.createServiceTicket("ST-1415133132-ompog68ygxKyX9BPwPuw0hESQBjuA", DateTime.now().plusSeconds(5).toInstant(), "https://slo.example.org/", new TicketState(session.getId(), "john", Instant.now(), "Password"), false);
        this.externalContext.getMockRequestParameterMap().put("service", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("ticket", ticket.getId());
        this.overrideEndStateOutput(FLOW_ID, "ValidateSuccess");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"ValidateSuccess");
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationSuccess>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:user>john</cas:user>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:proxyGrantingTicket>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:proxies>"));
        this.assertPopulatedAttributeContext((ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext"));
        IdPSession updatedSession = (IdPSession)this.sessionResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new SessionIdCriterion(session.getId())}));
        Assert.assertNotNull((Object)updatedSession);
        Assert.assertEquals((int)updatedSession.getSPSessions().size(), (int)1);
    }

    @Test
    public void testFailureTicketExpired() throws Exception {
        this.externalContext.getMockRequestParameterMap().put("service", "https://test.example.org/");
        this.externalContext.getMockRequestParameterMap().put("ticket", "ST-123-ABC");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ProtocolErrorView");
        String responseBody = this.response.getContentAsString();
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationFailure code=\"INVALID_TICKET\""));
        Assert.assertTrue((boolean)responseBody.contains("E_TICKET_EXPIRED"));
    }

    @Test
    public void testSuccessWithProxy() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ServiceTicket ticket = this.ticketService.createServiceTicket("ST-1415133132-ompog68ygxKyX9BPwPuw0hESQBjuA", DateTime.now().plusSeconds(5).toInstant(), "https://test.example.org/", new TicketState(session.getId(), "john", Instant.now(), "Password"), false);
        this.externalContext.getMockRequestParameterMap().put("service", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("ticket", ticket.getId());
        this.externalContext.getMockRequestParameterMap().put("pgtUrl", "https://proxy.example.com/");
        this.testProxyAuthenticator.setFailureFlag(false);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"ValidateSuccess");
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationSuccess>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:user>john</cas:user>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:proxyGrantingTicket>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:proxies>"));
        this.assertPopulatedAttributeContext((ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext"));
    }

    @Test
    public void testProxyCallbackAuthnFailure() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ServiceTicket ticket = this.ticketService.createServiceTicket("ST-1415133132-ompog68ygxKyX9BPwPuw0hESQBjuA", DateTime.now().plusSeconds(5).toInstant(), "https://test.example.org/", new TicketState(session.getId(), "john", Instant.now(), "Password"), false);
        this.externalContext.getMockRequestParameterMap().put("service", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("ticket", ticket.getId());
        this.externalContext.getMockRequestParameterMap().put("pgtUrl", "https://proxy.example.com/");
        this.overrideEndStateOutput(FLOW_ID, "ValidateSuccess");
        this.testProxyAuthenticator.setFailureFlag(true);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ProtocolErrorView");
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationFailure code=\"INVALID_REQUEST\""));
        Assert.assertTrue((boolean)responseBody.contains("E_PROXY_CALLBACK_AUTH_FAILURE"));
    }

    @Test
    public void testSuccessWithAltUsername() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ServiceTicket ticket = this.ticketService.createServiceTicket("ST-1415133132-pnqph79ygxKyX9BPwPuw0hESQBjuA", DateTime.now().plusSeconds(5).toInstant(), "https://alt-username.example.org/", new TicketState(session.getId(), "john", Instant.now(), "Password"), false);
        this.externalContext.getMockRequestParameterMap().put("service", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("ticket", ticket.getId());
        this.overrideEndStateOutput(FLOW_ID, "ValidateSuccess");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"ValidateSuccess");
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationSuccess>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:user>john@example.org</cas:user>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:proxyGrantingTicket>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:proxies>"));
        this.assertPopulatedAttributeContext((ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext"));
        IdPSession updatedSession = (IdPSession)this.sessionResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new SessionIdCriterion(session.getId())}));
        Assert.assertNotNull((Object)updatedSession);
        Assert.assertEquals((int)updatedSession.getSPSessions().size(), (int)0);
    }

    @Test
    public void testSuccessNoAttributes() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ServiceTicket ticket = this.ticketService.createServiceTicket("ST-2718281828-ompog68ygxKyX9BPwPuw0hESQBjuA", DateTime.now().plusSeconds(5).toInstant(), "https://no-attrs.example.org/", new TicketState(session.getId(), "john", Instant.now(), "Password"), false);
        this.externalContext.getMockRequestParameterMap().put("service", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("ticket", ticket.getId());
        this.overrideEndStateOutput(FLOW_ID, "ValidateSuccess");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"ValidateSuccess");
        Assert.assertTrue((boolean)responseBody.contains("<cas:authenticationSuccess>"));
        Assert.assertTrue((boolean)responseBody.contains("<cas:user>john</cas:user>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:attributes>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:uid>john</cas:uid>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:eduPersonPrincipalName>john</cas:eduPersonPrincipalName>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:mail>john@example.org</cas:mail>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:proxyGrantingTicket>"));
        Assert.assertFalse((boolean)responseBody.contains("<cas:proxies>"));
        IdPSession updatedSession = (IdPSession)this.sessionResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new SessionIdCriterion(session.getId())}));
        Assert.assertNotNull((Object)updatedSession);
        Assert.assertEquals((int)updatedSession.getSPSessions().size(), (int)0);
    }

    private void assertPopulatedAttributeContext(ProfileRequestContext prc) {
        Assert.assertNotNull((Object)prc);
        RelyingPartyContext rpc = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class, false);
        Assert.assertNotNull((Object)rpc);
        AttributeContext ac = (AttributeContext)rpc.getSubcontext(AttributeContext.class, false);
        Assert.assertNotNull((Object)ac);
        Assert.assertFalse((boolean)ac.getUnfilteredIdPAttributes().isEmpty());
    }

    private static ProxyAuthenticator<TrustEngine<X509Credential>> mockProxyAuthenticator(Exception toBeThrown) throws Exception {
        ProxyAuthenticator authenticator = (ProxyAuthenticator)Mockito.mock(ProxyAuthenticator.class);
        if (toBeThrown != null) {
            ((ProxyAuthenticator)Mockito.doThrow((Throwable)toBeThrown).when((Object)authenticator)).authenticate((URI)Matchers.any(URI.class), Matchers.any(TrustEngine.class));
        }
        return authenticator;
    }
}

