/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.cas;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketServiceEx;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.idp.test.flows.AbstractFlowTest;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.Test;

@ContextConfiguration(locations={"/test/test-cas-beans.xml"})
public class ValidateFlowTest
extends AbstractFlowTest {
    @Nonnull
    private static String FLOW_ID = "cas/validate";
    @Autowired
    @Qualifier(value="shibboleth.CASTicketService")
    private TicketServiceEx ticketService;
    @Autowired
    private SessionResolver sessionResolver;
    @Autowired
    private SessionManager sessionManager;

    @Test
    public void testSuccess() throws Exception {
        String principal = "john";
        IdPSession session = this.sessionManager.createSession("john");
        ServiceTicket ticket = this.ticketService.createServiceTicket("ST-1415133132-ompog68ygxKyX9BPwPuw0hESQBjuA", DateTime.now().plusSeconds(5).toInstant(), "https://test.example.org/", new TicketState(session.getId(), "john", Instant.now(), "Password"), false);
        this.externalContext.getMockRequestParameterMap().put("service", ticket.getService());
        this.externalContext.getMockRequestParameterMap().put("ticket", ticket.getId());
        this.overrideEndStateOutput(FLOW_ID, "ValidateSuccess");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        String responseBody = this.response.getContentAsString();
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"ValidateSuccess");
        Assert.assertTrue((boolean)responseBody.contentEquals("yes\njohn\n"));
        Assert.assertEquals((String)"text/plain;charset=utf-8", (String)this.response.getContentType());
        IdPSession updatedSession = (IdPSession)this.sessionResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new SessionIdCriterion(session.getId())}));
        Assert.assertNotNull((Object)updatedSession);
        Assert.assertEquals((int)updatedSession.getSPSessions().size(), (int)0);
    }

    @Test
    public void testFailureTicketExpired() throws Exception {
        this.externalContext.getMockRequestParameterMap().put("service", "https://test.example.org/");
        this.externalContext.getMockRequestParameterMap().put("ticket", "ST-123-ABC");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ProtocolErrorView");
        String responseBody = this.response.getContentAsString();
        Assert.assertTrue((boolean)responseBody.contentEquals("no\n\n"));
        Assert.assertEquals((String)"text/plain;charset=utf-8", (String)this.response.getContentType());
    }
}

