/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.exception;

import javax.annotation.Nonnull;
import net.shibboleth.idp.test.flows.AbstractFlowTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.Test;

@ContextConfiguration(locations={"classpath:/exception/test-webflow-config.xml"})
public class ExceptionFlowTest
extends AbstractFlowTest {
    @Nonnull
    public static final String TEST_EXCEPTION_FLOW_ID = "test-exception-flow";
    @Nonnull
    public static final String TEST_COMMITTED_FLOW_ID = "test-committed-flow";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExceptionFlowTest.class);

    @Test
    public void testExceptionFlow() {
        FlowExecutionResult result = this.flowExecutor.launchExecution(TEST_EXCEPTION_FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertFlowExecutionResult(result, TEST_EXCEPTION_FLOW_ID);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"ErrorView");
    }

    @Test
    public void testExceptionAfterResponseFlow() {
        try {
            this.flowExecutor.launchExecution(TEST_COMMITTED_FLOW_ID, null, (ExternalContext)this.externalContext);
            Assert.fail((String)"Flow should have thrown an exception.");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalStateException));
        }
    }
}

