/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.interceptor;

import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.idp.test.flows.AbstractFlowTest;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@ContextConfiguration(locations={"classpath:/intercept/test-webflow-config.xml"})
public class InterceptFlowTest
extends AbstractFlowTest {
    @Nonnull
    public static final String TEST_PROFILE_FLOW_ID = "test-intercept-flow";
    @Nonnull
    public static final String INTERCEPT_FLOWS_BEAN_ID = "shibboleth.AvailableInterceptFlows";
    @Nonnull
    public static final String ACTIVATED_FLOWS_BEAN_ID = "ActivatedFlows";
    @Nonnull
    public static final String TEST_FLOW_REGISTRY_ID = "testFlowRegistry";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InterceptFlowTest.class);

    @BeforeMethod
    public void setUserConfiguredInterceptFlows() {
        Flow flow = this.getFlow(TEST_PROFILE_FLOW_ID);
        List activatedFlows = (List)flow.getApplicationContext().getBean(ACTIVATED_FLOWS_BEAN_ID, List.class);
        activatedFlows.clear();
        List interceptFlows = (List)flow.getApplicationContext().getBean(INTERCEPT_FLOWS_BEAN_ID, List.class);
        interceptFlows.clear();
        ProfileInterceptorFlowDescriptor flowDescriptor1 = new ProfileInterceptorFlowDescriptor();
        flowDescriptor1.setId("intercept/test-proceed-1-flow");
        ProfileInterceptorFlowDescriptor flowDescriptor2 = new ProfileInterceptorFlowDescriptor();
        flowDescriptor2.setId("intercept/test-proceed-2-flow");
        ProfileInterceptorFlowDescriptor flowDescriptor3 = new ProfileInterceptorFlowDescriptor();
        flowDescriptor3.setId("intercept/test-error-flow");
        interceptFlows.add(flowDescriptor1);
        interceptFlows.add(flowDescriptor2);
        interceptFlows.add(flowDescriptor3);
    }

    @BeforeMethod
    public void registerFlowsInParentRegistry() {
        this.registerFlowsInParentRegistry("intercept/test-error-flow", TEST_FLOW_REGISTRY_ID);
        this.registerFlowsInParentRegistry("intercept/test-proceed-1-flow", TEST_FLOW_REGISTRY_ID);
        this.registerFlowsInParentRegistry("intercept/test-proceed-2-flow", TEST_FLOW_REGISTRY_ID);
    }

    @Test
    public void testNoAvailableFlows() {
        FlowExecutionResult result = this.flowExecutor.launchExecution(TEST_PROFILE_FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertFlowExecutionResult(result, TEST_PROFILE_FLOW_ID);
        this.assertFlowExecutionOutcome(result.getOutcome());
        ProfileRequestContext prc = this.retrieveProfileRequestContext(result);
        Assert.assertNotNull((Object)prc);
        ProfileInterceptorContext interceptorCtx = (ProfileInterceptorContext)prc.getSubcontext(ProfileInterceptorContext.class);
        Assert.assertTrue((boolean)interceptorCtx.getAvailableFlows().isEmpty());
        Assert.assertEquals((Object)result.getOutcome().getOutput().get("testProceed1"), (Object)false);
        Assert.assertEquals((Object)result.getOutcome().getOutput().get("testProceed2"), (Object)false);
    }

    @Test
    public void testOneAvailableFlow() {
        Flow flow = this.getFlow(TEST_PROFILE_FLOW_ID);
        List activatedFlows = (List)flow.getApplicationContext().getBean(ACTIVATED_FLOWS_BEAN_ID, List.class);
        activatedFlows.add("test-proceed-1-flow");
        FlowExecutionResult result = this.flowExecutor.launchExecution(TEST_PROFILE_FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertFlowExecutionResult(result, TEST_PROFILE_FLOW_ID);
        this.assertFlowExecutionOutcome(result.getOutcome());
        ProfileRequestContext prc = this.retrieveProfileRequestContext(result);
        Assert.assertNotNull((Object)prc);
        ProfileInterceptorContext interceptorCtx = (ProfileInterceptorContext)prc.getSubcontext(ProfileInterceptorContext.class);
        Assert.assertEquals((int)interceptorCtx.getAvailableFlows().size(), (int)0);
        Assert.assertEquals((Object)result.getOutcome().getOutput().get("testProceed1"), (Object)true);
        Assert.assertEquals((Object)result.getOutcome().getOutput().get("testProceed2"), (Object)false);
    }

    @Test
    public void testTwoAvailableFlows() {
        Flow flow = this.getFlow(TEST_PROFILE_FLOW_ID);
        List activatedFlows = (List)flow.getApplicationContext().getBean(ACTIVATED_FLOWS_BEAN_ID, List.class);
        activatedFlows.add("test-proceed-1-flow");
        activatedFlows.add("test-proceed-2-flow");
        FlowExecutionResult result = this.flowExecutor.launchExecution(TEST_PROFILE_FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertFlowExecutionResult(result, TEST_PROFILE_FLOW_ID);
        this.assertFlowExecutionOutcome(result.getOutcome());
        ProfileRequestContext prc = this.retrieveProfileRequestContext(result);
        Assert.assertNotNull((Object)prc);
        ProfileInterceptorContext interceptorCtx = (ProfileInterceptorContext)prc.getSubcontext(ProfileInterceptorContext.class);
        Assert.assertEquals((int)interceptorCtx.getAvailableFlows().size(), (int)0);
        Assert.assertEquals((Object)result.getOutcome().getOutput().get("testProceed1"), (Object)true);
        Assert.assertEquals((Object)result.getOutcome().getOutput().get("testProceed2"), (Object)true);
    }

    @Test
    public void testErrorFlow() {
        Flow flow = this.getFlow(TEST_PROFILE_FLOW_ID);
        List activatedFlows = (List)flow.getApplicationContext().getBean(ACTIVATED_FLOWS_BEAN_ID, List.class);
        activatedFlows.add("test-error-flow");
        FlowExecutionResult result = this.flowExecutor.launchExecution(TEST_PROFILE_FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertFlowExecutionResult(result, TEST_PROFILE_FLOW_ID);
        this.assertFlowExecutionOutcome(result.getOutcome(), "InvalidProfileContext");
        ProfileRequestContext prc = this.retrieveProfileRequestContext(result);
        Assert.assertNotNull((Object)prc);
        ProfileInterceptorContext interceptorCtx = (ProfileInterceptorContext)prc.getSubcontext(ProfileInterceptorContext.class);
        Assert.assertEquals((int)interceptorCtx.getAvailableFlows().size(), (int)1);
        Assert.assertEquals((Object)result.getOutcome().getOutput().get("testProceed1"), (Object)false);
        Assert.assertEquals((Object)result.getOutcome().getOutput().get("testProceed2"), (Object)false);
    }

    @Test
    public void testProceedThenErrorFlow() {
        Flow flow = this.getFlow(TEST_PROFILE_FLOW_ID);
        List activatedFlows = (List)flow.getApplicationContext().getBean(ACTIVATED_FLOWS_BEAN_ID, List.class);
        activatedFlows.add("test-proceed-1-flow");
        activatedFlows.add("test-error-flow");
        FlowExecutionResult result = this.flowExecutor.launchExecution(TEST_PROFILE_FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertFlowExecutionResult(result, TEST_PROFILE_FLOW_ID);
        this.assertFlowExecutionOutcome(result.getOutcome(), "InvalidProfileContext");
        ProfileRequestContext prc = this.retrieveProfileRequestContext(result);
        Assert.assertNotNull((Object)prc);
        ProfileInterceptorContext interceptorCtx = (ProfileInterceptorContext)prc.getSubcontext(ProfileInterceptorContext.class);
        Assert.assertEquals((int)interceptorCtx.getAvailableFlows().size(), (int)1);
        Assert.assertEquals((Object)result.getOutcome().getOutput().get("testProceed1"), (Object)true);
        Assert.assertEquals((Object)result.getOutcome().getOutput().get("testProceed2"), (Object)false);
    }
}

