/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.saml1;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.test.flows.AbstractFlowTest;
import net.shibboleth.idp.test.flows.saml1.SAML1TestResponseValidator;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml1.core.Response;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;

public abstract class AbstractSAML1FlowTest
extends AbstractFlowTest {
    public void validateResult(@Nullable FlowExecutionResult result, @Nonnull String flowId) {
        this.validateResult(result, flowId, new SAML1TestResponseValidator());
    }

    public void validateResult(@Nullable FlowExecutionResult result, @Nonnull String flowId, @Nonnull SAML1TestResponseValidator validator) {
        this.assertFlowExecutionResult(result, flowId);
        validator.validateResponse(this.getResponse(result));
    }

    public Response getResponse(@Nullable FlowExecutionResult result) {
        FlowExecutionOutcome outcome = result.getOutcome();
        this.assertFlowExecutionOutcome(outcome);
        ProfileRequestContext prc = (ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext");
        this.assertProfileRequestContext(prc);
        Assert.assertTrue((boolean)(prc.getOutboundMessageContext().getMessage() instanceof Response));
        return (Response)prc.getOutboundMessageContext().getMessage();
    }
}

