/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.saml1;

import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.test.flows.saml1.AbstractSAML1FlowTest;
import net.shibboleth.idp.test.flows.saml1.SAML1TestResponseValidator;
import net.shibboleth.utilities.java.support.security.SecureRandomIdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.core.Request;
import org.opensaml.saml.saml1.core.StatusCode;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.profile.SAML1ActionTestingSupport;
import org.opensaml.soap.soap11.Envelope;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Node;

public class SAML1AttributeQueryFlowTest
extends AbstractSAML1FlowTest {
    @Nonnull
    public static final String FLOW_ID = "SAML1/SOAP/AttributeQuery";
    @Nullable
    private SAML1TestResponseValidator validator;

    @BeforeClass
    void setupValidator() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameIdentifier.DEFAULT_ELEMENT_NAME);
        NameIdentifier nameIdentifier = (NameIdentifier)builder.buildObject();
        nameIdentifier.setValue("jdoe");
        nameIdentifier.setFormat(null);
        nameIdentifier.setNameQualifier(null);
        this.validator = new SAML1TestResponseValidator();
        this.validator.validateAuthenticationStatements = false;
        this.validator.nameIdentifier = nameIdentifier;
        this.validator.confirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
    }

    @Test
    public void testSAML1AttributeQueryFlow() throws Exception {
        this.buildRequest(false);
        this.request.setAttribute("javax.servlet.request.X509Certificate", (Object)new X509Certificate[]{this.certFactoryBean.getObject()});
        this.overrideEndStateOutput(FLOW_ID);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.validator.statusCode = StatusCode.SUCCESS;
        this.validator.usedAttributeDesignators = false;
        this.validateResult(result, FLOW_ID, this.validator);
    }

    @Test
    public void testSAML1AttributeQueryFlowWithDesignators() throws Exception {
        this.buildRequest(true);
        this.request.setAttribute("javax.servlet.request.X509Certificate", (Object)new X509Certificate[]{this.certFactoryBean.getObject()});
        this.overrideEndStateOutput(FLOW_ID);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.validator.statusCode = StatusCode.SUCCESS;
        this.validator.usedAttributeDesignators = true;
        this.validateResult(result, FLOW_ID, this.validator);
    }

    @Test
    public void testSAML1AttributeQueryFlowNoCredential() throws Exception {
        this.buildRequest(false);
        this.overrideEndStateOutput(FLOW_ID);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.validator.statusCode = StatusCode.REQUESTER;
        this.validator.usedAttributeDesignators = false;
        this.validateResult(result, FLOW_ID, this.validator);
    }

    public void buildRequest(boolean includeDesignators) throws Exception {
        Subject subject = SAML1ActionTestingSupport.buildSubject((String)"jdoe");
        Request attributeQuery = SAML1ActionTestingSupport.buildAttributeQueryRequest((Subject)subject);
        attributeQuery.setIssueInstant(new DateTime());
        attributeQuery.getAttributeQuery().setResource("https://sp.example.org");
        attributeQuery.setID(new SecureRandomIdentifierGenerationStrategy().generateIdentifier());
        if (includeDesignators) {
            SAMLObjectBuilder designatorBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AttributeDesignator.DEFAULT_ELEMENT_NAME);
            AttributeDesignator designator = (AttributeDesignator)designatorBuilder.buildObject();
            designator.setAttributeNamespace("urn:mace:shibboleth:1.0:attributeNamespace:uri");
            designator.setAttributeName("urn:mace:dir:attribute-def:eduPersonScopedAffiliation");
            attributeQuery.getAttributeQuery().getAttributeDesignators().add(designator);
            designator = (AttributeDesignator)designatorBuilder.buildObject();
            designator.setAttributeNamespace("urn:mace:shibboleth:1.0:attributeNamespace:uri");
            designator.setAttributeName("urn:mace:dir:attribute-def:mail");
            attributeQuery.getAttributeQuery().getAttributeDesignators().add(designator);
            designator = (AttributeDesignator)designatorBuilder.buildObject();
            designator.setAttributeNamespace("urn:mace:shibboleth:1.0:attributeNamespace:uri");
            designator.setAttributeName("urn:mace:dir:attribute-def:foo");
            attributeQuery.getAttributeQuery().getAttributeDesignators().add(designator);
        }
        Envelope envelope = SAML1AttributeQueryFlowTest.buildSOAP11Envelope((XMLObject)attributeQuery);
        String requestContent = SerializeSupport.nodeToString((Node)marshallerFactory.getMarshaller((XMLObject)envelope).marshall((XMLObject)envelope, parserPool.newDocument()));
        this.request.setMethod("POST");
        this.request.setContentType("text/xml");
        this.request.setContent(requestContent.getBytes("UTF-8"));
    }
}

