/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.saml1;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.Audience;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.ConfirmationMethod;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Status;
import org.opensaml.saml.saml1.core.StatusCode;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.core.SubjectConfirmation;
import org.testng.Assert;

public class SAML1TestResponseValidator {
    @Nonnull
    public String idpEntityID = "https://idp.example.org";
    @Nonnull
    public String spEntityID = "https://sp.example.org";
    @Nonnull
    public String authenticationMethod = "urn:oasis:names:tc:SAML:1.0:am:password";
    @Nonnull
    public String confirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:bearer";
    @Nonnull
    public NameIdentifier nameIdentifier;
    @Nonnull
    public QName statusCode = StatusCode.SUCCESS;
    @Nonnull
    public String statusMessage = "An error occurred.";
    public boolean validateAuthenticationStatements = true;
    public boolean usedAttributeDesignators = false;

    public SAML1TestResponseValidator() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameIdentifier.DEFAULT_ELEMENT_NAME);
        this.nameIdentifier = (NameIdentifier)builder.buildObject();
        this.nameIdentifier.setFormat("urn:mace:shibboleth:1.0:nameIdentifier");
        this.nameIdentifier.setNameQualifier(this.idpEntityID);
    }

    public void validateResponse(@Nullable Response response) {
        this.assertResponse(response);
        this.assertStatus(response.getStatus());
        if (this.statusCode != StatusCode.SUCCESS) {
            return;
        }
        List assertions = response.getAssertions();
        this.assertAssertions(assertions);
        Assertion assertion = (Assertion)assertions.get(0);
        this.assertAssertion(assertion);
        this.validateConditions(assertion);
        if (this.validateAuthenticationStatements) {
            this.validateAuthenticationStatements(assertion);
        }
        this.validateAttributeStatements(assertion);
    }

    public void validateConditions(@Nullable Assertion assertion) {
        Assert.assertNotNull((Object)assertion);
        Conditions conditions = assertion.getConditions();
        this.assertConditions(conditions);
        List audienceRestrictionConditions = conditions.getAudienceRestrictionConditions();
        this.assertAudienceRestrictionConditions(audienceRestrictionConditions);
        List audiences = ((AudienceRestrictionCondition)audienceRestrictionConditions.get(0)).getAudiences();
        this.assertAudiences(audiences);
    }

    public void validateAuthenticationStatements(@Nullable Assertion assertion) {
        Assert.assertNotNull((Object)assertion);
        List authenticationStatements = assertion.getAuthenticationStatements();
        this.assertAuthenticationStatements(authenticationStatements);
        AuthenticationStatement authenticationStatement = (AuthenticationStatement)authenticationStatements.get(0);
        this.assertAuthenticationStatement(authenticationStatement);
        Subject authenticationStatementSubject = authenticationStatement.getSubject();
        this.assertSubject(authenticationStatementSubject);
        this.assertAuthenticationMethod(authenticationStatement.getAuthenticationMethod());
    }

    public void validateAttributeStatements(@Nullable Assertion assertion) {
        Assert.assertNotNull((Object)assertion);
        List attributeStatements = assertion.getAttributeStatements();
        this.assertAttributeStatements(attributeStatements);
        AttributeStatement attributeStatement = (AttributeStatement)attributeStatements.get(0);
        this.assertAttributeStatement(attributeStatement);
        Subject attributeStatementSubject = attributeStatement.getSubject();
        this.assertSubject(attributeStatementSubject);
        NameIdentifier nameIdentifier = attributeStatementSubject.getNameIdentifier();
        this.assertNameIdentifier(nameIdentifier);
        SubjectConfirmation subjectConfirmation = attributeStatementSubject.getSubjectConfirmation();
        this.assertSubjectConfirmation(subjectConfirmation);
        List confirmationMethods = subjectConfirmation.getConfirmationMethods();
        this.assertConfirmationMethods(confirmationMethods);
        List attributes = attributeStatement.getAttributes();
        this.assertAttributes(attributes);
    }

    public void assertResponse(@Nullable Response response) {
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getID());
        Assert.assertFalse((boolean)response.getID().isEmpty());
        Assert.assertNotNull((Object)response.getIssueInstant());
        Assert.assertEquals((Object)response.getVersion(), (Object)SAMLVersion.VERSION_11);
    }

    public void assertStatus(@Nullable Status status) {
        Assert.assertNotNull((Object)status);
        Assert.assertNotNull((Object)status.getStatusCode());
        Assert.assertEquals((Object)status.getStatusCode().getValue(), (Object)this.statusCode);
        if (this.statusCode != StatusCode.SUCCESS) {
            Assert.assertEquals((String)status.getStatusMessage().getMessage(), (String)this.statusMessage);
        }
    }

    public void assertAssertions(@Nullable List<Assertion> assertions) {
        Assert.assertNotNull(assertions);
        Assert.assertFalse((boolean)assertions.isEmpty());
        Assert.assertEquals((int)assertions.size(), (int)1);
        Assert.assertNotNull((Object)assertions.get(0));
    }

    public void assertAssertion(@Nullable Assertion assertion) {
        Assert.assertNotNull((Object)assertion);
        Assert.assertNotNull((Object)assertion.getID());
        Assert.assertFalse((boolean)assertion.getID().isEmpty());
        Assert.assertNotNull((Object)assertion.getIssueInstant());
        Assert.assertEquals((int)assertion.getMajorVersion(), (int)SAMLVersion.VERSION_11.getMajorVersion());
        Assert.assertEquals((int)assertion.getMinorVersion(), (int)SAMLVersion.VERSION_11.getMinorVersion());
        Assert.assertEquals((String)assertion.getIssuer(), (String)this.idpEntityID);
    }

    public void assertAuthenticationStatements(@Nullable List<AuthenticationStatement> authenticationStatements) {
        Assert.assertNotNull(authenticationStatements);
        Assert.assertFalse((boolean)authenticationStatements.isEmpty());
        Assert.assertEquals((int)authenticationStatements.size(), (int)1);
        Assert.assertNotNull((Object)authenticationStatements.get(0));
    }

    public void assertAuthenticationStatement(@Nullable AuthenticationStatement authenticationStatement) {
        Assert.assertNotNull((Object)authenticationStatement);
        Assert.assertNotNull((Object)authenticationStatement.getSubject());
        Assert.assertNotNull((Object)authenticationStatement.getAuthenticationInstant());
        Assert.assertNotNull((Object)authenticationStatement.getAuthenticationMethod());
        Assert.assertFalse((boolean)authenticationStatement.getAuthenticationMethod().isEmpty());
    }

    public void assertAuthenticationMethod(@Nullable String method) {
        Assert.assertNotNull((Object)method);
        Assert.assertEquals((String)method, (String)this.authenticationMethod);
    }

    public void assertAudienceRestrictionConditions(@Nullable List<AudienceRestrictionCondition> audienceRestrictionConditions) {
        Assert.assertNotNull(audienceRestrictionConditions);
        Assert.assertEquals((int)audienceRestrictionConditions.size(), (int)1);
    }

    public void assertAudiences(@Nullable List<Audience> audiences) {
        Assert.assertNotNull(audiences);
        Assert.assertEquals((int)audiences.size(), (int)1);
        Assert.assertEquals((String)audiences.get(0).getUri(), (String)this.spEntityID);
    }

    public void assertConditions(@Nullable Conditions conditions) {
        Assert.assertNotNull((Object)conditions);
        Assert.assertNotNull((Object)conditions.getNotBefore());
        Assert.assertNotNull((Object)conditions.getNotOnOrAfter());
        Assert.assertNotNull((Object)conditions.getAudienceRestrictionConditions());
        Assert.assertEquals((int)conditions.getAudienceRestrictionConditions().size(), (int)1);
    }

    public void assertAttributeStatements(@Nullable List<AttributeStatement> attributeStatements) {
        Assert.assertNotNull(attributeStatements);
        Assert.assertFalse((boolean)attributeStatements.isEmpty());
        Assert.assertEquals((int)attributeStatements.size(), (int)1);
        Assert.assertNotNull((Object)attributeStatements.get(0));
    }

    public void assertAttributeStatement(@Nullable AttributeStatement attributeStatement) {
        Assert.assertNotNull((Object)attributeStatement);
        Assert.assertNotNull((Object)attributeStatement.getSubject());
        Assert.assertNotNull((Object)attributeStatement.getAttributes());
    }

    public void assertSubject(@Nullable Subject subject) {
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameIdentifier());
        Assert.assertNotNull((Object)subject.getSubjectConfirmation());
    }

    public void assertNameIdentifier(@Nullable NameIdentifier identifier) {
        Assert.assertNotNull((Object)identifier);
        Assert.assertNotNull((Object)identifier.getValue());
        if (this.nameIdentifier.getFormat() != null && !this.nameIdentifier.getFormat().equals("urn:mace:shibboleth:1.0:nameIdentifier")) {
            Assert.assertEquals((String)identifier.getValue(), (String)this.nameIdentifier.getValue());
        }
        Assert.assertEquals((String)identifier.getFormat(), (String)this.nameIdentifier.getFormat());
        Assert.assertEquals((String)identifier.getNameQualifier(), (String)this.nameIdentifier.getNameQualifier());
    }

    public void assertSubjectConfirmation(@Nullable SubjectConfirmation subjectConfirmation) {
        Assert.assertNotNull((Object)subjectConfirmation);
        Assert.assertEquals((int)subjectConfirmation.getConfirmationMethods().size(), (int)1);
    }

    public void assertConfirmationMethods(@Nullable List<ConfirmationMethod> confirmationMethods) {
        Assert.assertNotNull(confirmationMethods);
        Assert.assertFalse((boolean)confirmationMethods.isEmpty());
        Assert.assertEquals((int)confirmationMethods.size(), (int)1);
        Assert.assertNotNull((Object)confirmationMethods.get(0));
        this.assertConfirmationMethod(confirmationMethods.get(0));
    }

    public void assertConfirmationMethod(@Nullable ConfirmationMethod method) {
        Assert.assertNotNull((Object)method);
        Assert.assertEquals((String)method.getConfirmationMethod(), (String)this.confirmationMethod);
    }

    public void assertAttributes(@Nullable List<Attribute> attributes) {
        Assert.assertNotNull(attributes);
        Assert.assertFalse((boolean)attributes.isEmpty());
        Assert.assertEquals((int)attributes.size(), (int)(this.usedAttributeDesignators ? 2 : 4));
        HashMap<String, Attribute> actualAttributes = new HashMap<String, Attribute>();
        for (Attribute attribute : attributes) {
            actualAttributes.put(attribute.getAttributeName(), attribute);
        }
        if (this.usedAttributeDesignators) {
            Attribute actualMailAttribute = (Attribute)actualAttributes.get("urn:mace:dir:attribute-def:mail");
            Assert.assertNotNull((Object)actualMailAttribute);
            this.assertAttribute(actualMailAttribute, "urn:mace:dir:attribute-def:mail", "jdoe@example.org");
            Attribute actualEPSAAttribute = (Attribute)actualAttributes.get("urn:mace:dir:attribute-def:eduPersonScopedAffiliation");
            Assert.assertNotNull((Object)actualEPSAAttribute);
            this.assertAttribute(actualEPSAAttribute, "urn:mace:dir:attribute-def:eduPersonScopedAffiliation", "member");
        } else {
            Attribute actualUidAttribute = (Attribute)actualAttributes.get("urn:mace:dir:attribute-def:uid");
            Assert.assertNotNull((Object)actualUidAttribute);
            this.assertAttribute(actualUidAttribute, "urn:mace:dir:attribute-def:uid", "jdoe");
            Attribute actualMailAttribute = (Attribute)actualAttributes.get("urn:mace:dir:attribute-def:mail");
            Assert.assertNotNull((Object)actualMailAttribute);
            this.assertAttribute(actualMailAttribute, "urn:mace:dir:attribute-def:mail", "jdoe@example.org");
            Attribute actualEPPNAttribute = (Attribute)actualAttributes.get("urn:mace:dir:attribute-def:eduPersonPrincipalName");
            Assert.assertNotNull((Object)actualEPPNAttribute);
            this.assertAttribute(actualEPPNAttribute, "urn:mace:dir:attribute-def:eduPersonPrincipalName", "jdoe");
            Attribute actualEPSAAttribute = (Attribute)actualAttributes.get("urn:mace:dir:attribute-def:eduPersonScopedAffiliation");
            Assert.assertNotNull((Object)actualEPSAAttribute);
            this.assertAttribute(actualEPSAAttribute, "urn:mace:dir:attribute-def:eduPersonScopedAffiliation", "member");
        }
    }

    public void assertAttribute(@Nullable Attribute attribute, @Nonnull String attributeName, @Nonnull String attributeValue) {
        Assert.assertNotNull((Object)attribute);
        Assert.assertEquals((String)attribute.getAttributeName(), (String)attributeName);
        Assert.assertEquals((String)attribute.getAttributeNamespace(), (String)"urn:mace:shibboleth:1.0:attributeNamespace:uri");
        Assert.assertEquals((int)attribute.getAttributeValues().size(), (int)1);
        Assert.assertTrue((boolean)(attribute.getAttributeValues().get(0) instanceof XSAny));
        Assert.assertEquals((String)((XSAny)attribute.getAttributeValues().get(0)).getTextContent(), (String)attributeValue);
    }
}

