/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.saml2;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.test.flows.AbstractFlowTest;
import net.shibboleth.idp.test.flows.saml2.SAML2TestResponseValidator;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Response;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;

public class AbstractSAML2FlowTest
extends AbstractFlowTest {
    public void validateResult(@Nullable FlowExecutionResult result, @Nonnull String flowId) {
        SAML2TestResponseValidator validator = new SAML2TestResponseValidator();
        validator.spCredential = this.spCredential;
        this.validateResult(result, flowId, validator);
    }

    public void validateResult(@Nullable FlowExecutionResult result, @Nonnull String flowId, @Nonnull SAML2TestResponseValidator validator) {
        this.assertFlowExecutionResult(result, flowId);
        validator.validateResponse(this.getResponse(result));
    }

    public Response getResponse(@Nullable FlowExecutionResult result) {
        FlowExecutionOutcome outcome = result.getOutcome();
        this.assertFlowExecutionOutcome(outcome);
        ProfileRequestContext prc = (ProfileRequestContext)outcome.getOutput().get("ProfileRequestContext");
        this.assertProfileRequestContext(prc);
        Assert.assertTrue((boolean)(prc.getOutboundMessageContext().getMessage() instanceof Response));
        return (Response)prc.getOutboundMessageContext().getMessage();
    }
}

