/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.saml2;

import java.net.MalformedURLException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.test.flows.saml2.AbstractSAML2FlowTest;
import net.shibboleth.utilities.java.support.net.SimpleURLCanonicalizer;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAML2SSOFlowTest
extends AbstractSAML2FlowTest {
    @Nonnull
    protected final Logger log = LoggerFactory.getLogger(AbstractSAML2SSOFlowTest.class);

    public String getDestinationRedirect(HttpServletRequest servletRequest) {
        String destinationPath = "/idp/profile/SAML2/Redirect/SSO";
        try {
            String baseUrl = SimpleURLCanonicalizer.canonicalize((String)this.getBaseUrl(servletRequest));
            URLBuilder urlBuilder = new URLBuilder(baseUrl);
            urlBuilder.setPath(destinationPath);
            return urlBuilder.buildURL();
        }
        catch (MalformedURLException e) {
            this.log.error("Couldn't parse base URL, reverting to internal default destination");
            return "http://localhost:8080" + destinationPath;
        }
    }

    public String getDestinationPost(HttpServletRequest servletRequest) {
        String destinationPath = "/idp/profile/SAML2/POST/SSO";
        String baseUrl = this.getBaseUrl(servletRequest);
        try {
            URLBuilder urlBuilder = new URLBuilder(baseUrl);
            urlBuilder.setPath(destinationPath);
            return urlBuilder.buildURL();
        }
        catch (MalformedURLException e) {
            this.log.error("Couldn't parse base URL, reverting to internal default destination: {}", (Object)baseUrl);
            return "http://localhost:8080" + destinationPath;
        }
    }

    public String getDestinationPostSimpleSign(HttpServletRequest servletRequest) {
        String destinationPath = "/idp/profile/SAML2/POST-SimpleSign/SSO";
        String baseUrl = this.getBaseUrl(servletRequest);
        try {
            URLBuilder urlBuilder = new URLBuilder(baseUrl);
            urlBuilder.setPath(destinationPath);
            return urlBuilder.buildURL();
        }
        catch (MalformedURLException e) {
            this.log.error("Couldn't parse base URL, reverting to internal default destination: {}", (Object)baseUrl);
            return "http://localhost:8080" + destinationPath;
        }
    }

    public AuthnRequest buildAuthnRequest(HttpServletRequest servletRequest) throws EncryptionException {
        AuthnRequest authnRequest = (AuthnRequest)builderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME).buildObject(AuthnRequest.DEFAULT_ELEMENT_NAME);
        authnRequest.setID(this.idGenerator.generateIdentifier());
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setAssertionConsumerServiceURL(this.getAcsUrl(servletRequest));
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Issuer issuer = (Issuer)builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME).buildObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue("https://sp.example.org");
        authnRequest.setIssuer(issuer);
        NameIDPolicy nameIDPolicy = (NameIDPolicy)builderFactory.getBuilder(NameIDPolicy.DEFAULT_ELEMENT_NAME).buildObject(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        nameIDPolicy.setAllowCreate(Boolean.valueOf(true));
        authnRequest.setNameIDPolicy(nameIDPolicy);
        NameID nameID = (NameID)builderFactory.getBuilder(NameID.DEFAULT_ELEMENT_NAME).buildObject(NameID.DEFAULT_ELEMENT_NAME);
        nameID.setValue("jdoe");
        Subject subject = (Subject)builderFactory.getBuilder(Subject.DEFAULT_ELEMENT_NAME).buildObject(Subject.DEFAULT_ELEMENT_NAME);
        subject.setEncryptedID(this.getEncrypter().encrypt(nameID));
        authnRequest.setSubject(subject);
        RequestedAuthnContext reqAC = (RequestedAuthnContext)builderFactory.getBuilder(RequestedAuthnContext.DEFAULT_ELEMENT_NAME).buildObject(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        AuthnContextClassRef ac = (AuthnContextClassRef)builderFactory.getBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME).buildObject(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        ac.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
        reqAC.getAuthnContextClassRefs().add(ac);
        authnRequest.setRequestedAuthnContext(reqAC);
        return authnRequest;
    }

    public Encrypter getEncrypter() {
        DataEncryptionParameters encParams = new DataEncryptionParameters();
        encParams.setAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        KeyEncryptionParameters kencParams = new KeyEncryptionParameters();
        kencParams.setAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        kencParams.setEncryptionCredential(this.idpCredential);
        X509KeyInfoGeneratorFactory generator = new X509KeyInfoGeneratorFactory();
        generator.setEmitEntityCertificate(true);
        kencParams.setKeyInfoGenerator(generator.newInstance());
        Encrypter encrypter = new Encrypter(encParams, kencParams);
        encrypter.setKeyPlacement(Encrypter.KeyPlacement.PEER);
        return encrypter;
    }

    public String getAcsUrl(HttpServletRequest servletRequest) {
        String acsPath = "/sp/SAML2/POST/ACS";
        String baseUrl = this.getBaseUrl(servletRequest);
        try {
            URLBuilder urlBuilder = new URLBuilder(SimpleURLCanonicalizer.canonicalize((String)baseUrl));
            urlBuilder.setPath(acsPath);
            return urlBuilder.buildURL();
        }
        catch (MalformedURLException e) {
            this.log.error("Couldn't parse base URL, reverting to internal default ACS: {}", (Object)baseUrl);
            return "http://localhost:8080" + acsPath;
        }
    }

    public SingleSignOnService buildIdpSsoEndpoint(String binding, String destination) {
        SingleSignOnService ssoEndpoint = (SingleSignOnService)builderFactory.getBuilder(SingleSignOnService.DEFAULT_ELEMENT_NAME).buildObject(SingleSignOnService.DEFAULT_ELEMENT_NAME);
        ssoEndpoint.setBinding(binding);
        ssoEndpoint.setLocation(destination);
        return ssoEndpoint;
    }

    public String getBaseUrl(HttpServletRequest servletRequest) {
        String requestUrl = servletRequest.getRequestURL().toString();
        try {
            URLBuilder urlBuilder = new URLBuilder(requestUrl);
            urlBuilder.setUsername(null);
            urlBuilder.setPassword(null);
            urlBuilder.setPath(null);
            urlBuilder.getQueryParams().clear();
            urlBuilder.setFragment(null);
            return urlBuilder.buildURL();
        }
        catch (MalformedURLException e) {
            this.log.error("Couldn't parse request URL, reverting to internal default base URL: {}", (Object)requestUrl);
            return "http://localhost:8080";
        }
    }

    public MessageContext<SAMLObject> buildOutboundMessageContext(AuthnRequest authnRequest, String bindingUri) {
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)authnRequest);
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true);
        peerContext.setEntityId("https://idp.example.org");
        SAMLEndpointContext endpointContext = (SAMLEndpointContext)peerContext.getSubcontext(SAMLEndpointContext.class, true);
        endpointContext.setEndpoint((Endpoint)this.buildIdpSsoEndpoint(bindingUri, authnRequest.getDestination()));
        SignatureSigningParameters signingParameters = new SignatureSigningParameters();
        signingParameters.setSigningCredential(this.spCredential);
        SecurityParametersContext secParamsContext = (SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class, true);
        secParamsContext.setSignatureSigningParameters(signingParameters);
        return messageContext;
    }
}

