/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.saml2;

import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.test.flows.saml2.AbstractSAML2FlowTest;
import net.shibboleth.idp.test.flows.saml2.SAML2TestResponseValidator;
import net.shibboleth.utilities.java.support.security.SecureRandomIdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.opensaml.soap.soap11.Envelope;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Node;

public class SAML2AttributeQueryFlowTest
extends AbstractSAML2FlowTest {
    @Nonnull
    public static final String FLOW_ID = "SAML2/SOAP/AttributeQuery";
    @Nullable
    private SAML2TestResponseValidator validator;

    @BeforeClass
    void setupValidator() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameID.DEFAULT_ELEMENT_NAME);
        NameID nameID = (NameID)builder.buildObject();
        nameID.setValue("jdoe");
        nameID.setNameQualifier(null);
        nameID.setSPNameQualifier(null);
        nameID.setFormat(null);
        this.validator = new SAML2TestResponseValidator();
        this.validator.nameID = nameID;
        this.validator.spCredential = this.spCredential;
        this.validator.subjectConfirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
        this.validator.validateAuthnStatements = false;
        this.validator.validateSubjectConfirmationData = false;
    }

    @Test
    public void testSAML2AttributeQueryFlow() throws Exception {
        this.buildRequest(false);
        this.request.setAttribute("javax.servlet.request.X509Certificate", (Object)new X509Certificate[]{this.certFactoryBean.getObject()});
        this.overrideEndStateOutput(FLOW_ID);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.validator.statusCode = "urn:oasis:names:tc:SAML:2.0:status:Success";
        this.validator.usedAttributeDesignators = false;
        this.validateResult(result, FLOW_ID, this.validator);
    }

    @Test
    public void testSAML2AttributeQueryFlowWithDesignators() throws Exception {
        this.buildRequest(true);
        this.request.setAttribute("javax.servlet.request.X509Certificate", (Object)new X509Certificate[]{this.certFactoryBean.getObject()});
        this.overrideEndStateOutput(FLOW_ID);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.validator.statusCode = "urn:oasis:names:tc:SAML:2.0:status:Success";
        this.validator.usedAttributeDesignators = true;
        this.validateResult(result, FLOW_ID, this.validator);
    }

    @Test
    public void testSAML2AttributeQueryFlowNoCredential() throws Exception {
        this.buildRequest(false);
        this.overrideEndStateOutput(FLOW_ID);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.validator.statusCode = "urn:oasis:names:tc:SAML:2.0:status:Requester";
        this.validator.usedAttributeDesignators = false;
        this.validateResult(result, FLOW_ID, this.validator);
    }

    public void buildRequest(boolean includeDesignators) throws Exception {
        Subject subject = SAML2ActionTestingSupport.buildSubject((String)"jdoe");
        AttributeQuery attributeQuery = SAML2ActionTestingSupport.buildAttributeQueryRequest((Subject)subject);
        attributeQuery.setIssueInstant(new DateTime());
        attributeQuery.getIssuer().setValue("https://sp.example.org");
        attributeQuery.setID(new SecureRandomIdentifierGenerationStrategy().generateIdentifier());
        if (includeDesignators) {
            SAMLObjectBuilder designatorBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Attribute.DEFAULT_ELEMENT_NAME);
            XMLObjectBuilder valueBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSAny.TYPE_NAME);
            Attribute designator = (Attribute)designatorBuilder.buildObject();
            designator.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
            designator.setName("urn:oid:0.9.2342.19200300.100.1.3");
            attributeQuery.getAttributes().add(designator);
            XSAny value = (XSAny)valueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
            value.setTextContent("jdoe@example.org");
            designator.getAttributeValues().add(value);
            designator = (Attribute)designatorBuilder.buildObject();
            designator.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
            designator.setName("urn:mace:dir:attribute-def:foo");
            attributeQuery.getAttributes().add(designator);
        }
        Envelope envelope = SAML2AttributeQueryFlowTest.buildSOAP11Envelope((XMLObject)attributeQuery);
        String requestContent = SerializeSupport.nodeToString((Node)marshallerFactory.getMarshaller((XMLObject)envelope).marshall((XMLObject)envelope, parserPool.newDocument()));
        this.request.setMethod("POST");
        this.request.setContentType("text/xml");
        this.request.setContent(requestContent.getBytes("UTF-8"));
    }
}

