/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.saml2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.test.flows.saml2.AbstractSAML2SSOFlowTest;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2RedirectSSOFlowTest
extends AbstractSAML2SSOFlowTest {
    @Nonnull
    public static final String FLOW_ID = "SAML2/Redirect/SSO";

    @Test
    public void testSAML2RedirectFlow() throws Exception {
        this.buildRequest();
        this.overrideEndStateOutput(FLOW_ID);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.validateResult(result, FLOW_ID);
    }

    public void buildRequest() throws Exception {
        this.request.setMethod("GET");
        this.request.setRequestURI("/idp/profile/SAML2/Redirect/SSO");
        AuthnRequest authnRequest = this.buildAuthnRequest((HttpServletRequest)this.request);
        authnRequest.setDestination(this.getDestinationRedirect((HttpServletRequest)this.request));
        MessageContext<SAMLObject> messageContext = this.buildOutboundMessageContext(authnRequest, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        SAMLObject message = (SAMLObject)messageContext.getMessage();
        String encodedMessage = this.encodeMessage(message);
        this.request.addParameter("SAMLRequest", encodedMessage);
    }

    @Nonnull
    public String encodeMessage(@Nonnull SAMLObject message) throws MarshallingException, IOException {
        Element domMessage = XMLObjectSupport.marshall((XMLObject)message);
        String messageXML = SerializeSupport.nodeToString((Node)domMessage);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(8, true);
        DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)bytesOut, deflater);
        deflaterStream.write(messageXML.getBytes("UTF-8"));
        deflaterStream.finish();
        return Base64Support.encode((byte[])bytesOut.toByteArray(), (boolean)false);
    }
}

