/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.saml2;

import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.test.flows.saml2.SAML2TestStatusResponseTypeValidator;
import net.shibboleth.utilities.java.support.net.IPRange;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.AttributeValue;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.testng.Assert;

public class SAML2TestResponseValidator
extends SAML2TestStatusResponseTypeValidator {
    @Nonnull
    public String authnContextClassRef = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
    @Nullable
    public Credential spCredential;
    @Nonnull
    public NameID nameID;
    @Nonnull
    public String subjectConfirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    @Nonnull
    public IPRange subjectConfirmationDataAddressRange = IPRange.parseCIDRBlock((String)"127.0.0.1/32");
    @Nonnull
    public IPRange subjectConfirmationDataAddressRangeV6 = IPRange.parseCIDRBlock((String)"::1/128");
    @Nonnull
    public boolean validateAuthnStatements = true;
    @Nonnull
    public boolean validateSubjectConfirmationData = true;
    public boolean usedAttributeDesignators = false;
    @Nonnull
    public List<Attribute> expectedAttributes;
    @Nonnull
    public List<Attribute> expectedDesignatedAttributes;
    @Nonnull
    public Attribute uidAttribute;
    @Nonnull
    public Attribute eppnAttribute;
    @Nonnull
    public Attribute mailAttribute;
    @Nonnull
    public Attribute eduPersonScopedAffiliationAttribute;

    public SAML2TestResponseValidator() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameID.DEFAULT_ELEMENT_NAME);
        this.nameID = (NameID)builder.buildObject();
        this.nameID.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        this.nameID.setNameQualifier(this.idpEntityID);
        this.nameID.setSPNameQualifier(this.spEntityID);
        this.buildExpectedAttributes();
    }

    protected void buildExpectedAttributes() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Attribute.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder anyBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSAny.TYPE_NAME);
        this.uidAttribute = (Attribute)builder.buildObject();
        this.uidAttribute.setName("urn:oid:0.9.2342.19200300.100.1.1");
        this.uidAttribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        this.uidAttribute.setFriendlyName("uid");
        XSAny uidValue = (XSAny)anyBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        uidValue.setTextContent("jdoe");
        this.uidAttribute.getAttributeValues().add(uidValue);
        this.eppnAttribute = (Attribute)builder.buildObject();
        this.eppnAttribute.setName("urn:oid:1.3.6.1.4.1.5923.1.1.1.6");
        this.eppnAttribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        this.eppnAttribute.setFriendlyName("eduPersonPrincipalName");
        XSAny eppnValue = (XSAny)anyBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        eppnValue.setTextContent("jdoe@example.org");
        this.eppnAttribute.getAttributeValues().add(eppnValue);
        this.mailAttribute = (Attribute)builder.buildObject();
        this.mailAttribute.setName("urn:oid:0.9.2342.19200300.100.1.3");
        this.mailAttribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        this.mailAttribute.setFriendlyName("mail");
        XSAny mailValue = (XSAny)anyBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        mailValue.setTextContent("jdoe@example.org");
        this.mailAttribute.getAttributeValues().add(mailValue);
        this.eduPersonScopedAffiliationAttribute = (Attribute)builder.buildObject();
        this.eduPersonScopedAffiliationAttribute.setName("urn:oid:1.3.6.1.4.1.5923.1.1.1.9");
        this.eduPersonScopedAffiliationAttribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        this.eduPersonScopedAffiliationAttribute.setFriendlyName("eduPersonScopedAffiliation");
        XSAny eduPersonScopedAffiliationAttributeValue = (XSAny)anyBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        eduPersonScopedAffiliationAttributeValue.setTextContent("member@example.org");
        this.eduPersonScopedAffiliationAttribute.getAttributeValues().add(eduPersonScopedAffiliationAttributeValue);
        this.expectedAttributes = new ArrayList<Attribute>();
        this.expectedAttributes.add(this.uidAttribute);
        this.expectedAttributes.add(this.mailAttribute);
        this.expectedAttributes.add(this.eppnAttribute);
        this.expectedAttributes.add(this.eduPersonScopedAffiliationAttribute);
        this.expectedDesignatedAttributes = new ArrayList<Attribute>();
        this.expectedDesignatedAttributes.add(this.mailAttribute);
    }

    private Assertion decryptAssertion(EncryptedAssertion encrypted) throws DecryptionException {
        ArrayList<Object> resolverChain = new ArrayList<Object>();
        resolverChain.add(new InlineEncryptedKeyResolver());
        resolverChain.add(new EncryptedElementTypeEncryptedKeyResolver());
        ChainingEncryptedKeyResolver chain = new ChainingEncryptedKeyResolver(resolverChain);
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)new StaticKeyInfoCredentialResolver(this.spCredential), (EncryptedKeyResolver)chain);
        return decrypter.decrypt(encrypted);
    }

    public void validateResponse(@Nullable Response response) {
        super.validateResponse((StatusResponseType)response);
        if (this.statusCode != "urn:oasis:names:tc:SAML:2.0:status:Success") {
            return;
        }
        if (!response.getEncryptedAssertions().isEmpty()) {
            try {
                response.getAssertions().add(this.decryptAssertion((EncryptedAssertion)response.getEncryptedAssertions().get(0)));
                response.getEncryptedAssertions().clear();
            }
            catch (DecryptionException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        List assertions = response.getAssertions();
        this.assertAssertions(assertions);
        Assertion assertion = (Assertion)assertions.get(0);
        this.assertAssertion(assertion);
        this.validateSubject(assertion.getSubject());
        this.validateConditions(assertion);
        if (this.validateAuthnStatements) {
            this.validateAuthnStatements(assertion);
        }
        this.validateAttributeStatements(assertion);
    }

    public void validateSubject(@Nullable Subject subject) {
        this.assertSubject(subject);
        this.assertNameID(subject.getNameID());
        this.assertSubjectConfirmations(subject.getSubjectConfirmations());
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)subject.getSubjectConfirmations().get(0);
        this.assertSubjectConfirmation(subjectConfirmation);
        this.assertSubjectConfirmationMethod(subjectConfirmation);
        if (this.validateSubjectConfirmationData) {
            this.assertSubjectConfirmationData(subjectConfirmation.getSubjectConfirmationData());
        }
    }

    public void validateConditions(@Nullable Assertion assertion) {
        Assert.assertNotNull((Object)assertion);
        Conditions conditions = assertion.getConditions();
        this.assertConditions(conditions);
        List audienceRestrictions = conditions.getAudienceRestrictions();
        this.assertAudienceRestrictions(audienceRestrictions);
        this.assertAudienceRestriction((AudienceRestriction)audienceRestrictions.get(0));
    }

    public void validateAuthnStatements(@Nullable Assertion assertion) {
        Assert.assertNotNull((Object)assertion);
        List authnStatements = assertion.getAuthnStatements();
        this.assertAuthnStatements(authnStatements);
        AuthnStatement authnStatement = (AuthnStatement)authnStatements.get(0);
        this.assertAuthnStatement(authnStatement);
        this.assertAuthnContextClassRef(authnStatement.getAuthnContext().getAuthnContextClassRef());
    }

    public void validateAttributeStatements(@Nullable Assertion assertion) {
        Assert.assertNotNull((Object)assertion);
        List attributeStatements = assertion.getAttributeStatements();
        this.assertAttributeStatements(attributeStatements);
        AttributeStatement attributeStatement = (AttributeStatement)attributeStatements.get(0);
        this.assertAttributeStatement(attributeStatement);
        List attributes = attributeStatement.getAttributes();
        this.assertAttributes(attributes);
    }

    public void assertAssertions(@Nullable List<Assertion> assertions) {
        Assert.assertNotNull(assertions);
        Assert.assertFalse((boolean)assertions.isEmpty());
        Assert.assertEquals((int)assertions.size(), (int)1);
        Assert.assertNotNull((Object)assertions.get(0));
    }

    public void assertAssertion(@Nullable Assertion assertion) {
        Assert.assertNotNull((Object)assertion);
        Assert.assertNotNull((Object)assertion.getID());
        Assert.assertFalse((boolean)assertion.getID().isEmpty());
        Assert.assertNotNull((Object)assertion.getIssueInstant());
        Assert.assertEquals((Object)assertion.getVersion(), (Object)SAMLVersion.VERSION_20);
        Assert.assertEquals((String)assertion.getIssuer().getValue(), (String)this.idpEntityID);
    }

    public void assertSubject(@Nullable Subject subject) {
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameID());
        Assert.assertNotNull((Object)subject.getSubjectConfirmations());
    }

    public void assertSubjectConfirmations(@Nullable List<SubjectConfirmation> subjectConfirmations) {
        Assert.assertNotNull(subjectConfirmations);
        Assert.assertEquals((int)subjectConfirmations.size(), (int)1);
    }

    public void assertSubjectConfirmation(@Nullable SubjectConfirmation subjectConfirmation) {
        Assert.assertNotNull((Object)subjectConfirmation);
        Assert.assertNotNull((Object)subjectConfirmation.getMethod());
    }

    public void assertSubjectConfirmationMethod(@Nullable SubjectConfirmation method) {
        Assert.assertEquals((String)method.getMethod(), (String)this.subjectConfirmationMethod);
    }

    public void assertSubjectConfirmationData(@Nullable SubjectConfirmationData subjectConfirmationData) {
        InetAddress address = InetAddresses.forString((String)subjectConfirmationData.getAddress());
        if (address instanceof Inet4Address) {
            Assert.assertTrue((boolean)this.subjectConfirmationDataAddressRange.contains(address));
        } else if (address instanceof Inet6Address) {
            Assert.assertTrue((boolean)this.subjectConfirmationDataAddressRangeV6.contains(address));
        } else {
            Assert.fail((String)"Unable to determine whether the IP address is V4 or V6");
        }
        Assert.assertNotNull((Object)subjectConfirmationData.getNotOnOrAfter());
        Assert.assertNotNull((Object)subjectConfirmationData.getRecipient());
        Assert.assertFalse((boolean)subjectConfirmationData.getRecipient().isEmpty());
    }

    public void assertNameID(@Nullable NameID id) {
        Assert.assertNotNull((Object)id);
        Assert.assertNotNull((Object)id.getValue());
        if (this.nameID.getFormat() != null && !this.nameID.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:transient")) {
            Assert.assertEquals((String)id.getValue(), (String)this.nameID.getValue());
        }
        Assert.assertEquals((String)id.getFormat(), (String)this.nameID.getFormat());
        Assert.assertEquals((String)id.getNameQualifier(), (String)this.nameID.getNameQualifier());
        Assert.assertEquals((String)id.getSPNameQualifier(), (String)this.nameID.getSPNameQualifier());
    }

    public void assertConditions(@Nullable Conditions conditions) {
        Assert.assertNotNull((Object)conditions);
        Assert.assertNotNull((Object)conditions.getNotBefore());
        Assert.assertNotNull((Object)conditions.getNotOnOrAfter());
    }

    public void assertAudienceRestrictions(@Nullable List<AudienceRestriction> audienceRestrictions) {
        Assert.assertNotNull(audienceRestrictions);
        Assert.assertEquals((int)audienceRestrictions.size(), (int)1);
    }

    public void assertAudienceRestriction(@Nullable AudienceRestriction audienceRestriction) {
        Assert.assertNotNull((Object)audienceRestriction);
        List audiences = audienceRestriction.getAudiences();
        Assert.assertEquals((int)audiences.size(), (int)1);
        Audience audience = (Audience)audiences.get(0);
        Assert.assertEquals((String)audience.getAudienceURI(), (String)"https://sp.example.org");
    }

    public void assertAuthnStatements(@Nullable List<AuthnStatement> authnStatements) {
        Assert.assertNotNull(authnStatements);
        Assert.assertEquals((int)authnStatements.size(), (int)1);
        Assert.assertNotNull((Object)authnStatements.get(0));
    }

    public void assertAuthnStatement(@Nonnull AuthnStatement authnStatement) {
        Assert.assertNotNull((Object)authnStatement);
        Assert.assertNotNull((Object)authnStatement.getAuthnInstant());
        Assert.assertNotNull((Object)authnStatement.getAuthnContext());
        Assert.assertNotNull((Object)authnStatement.getAuthnContext().getAuthnContextClassRef());
    }

    public void assertAuthnContextClassRef(@Nullable AuthnContextClassRef authnContext) {
        Assert.assertEquals((String)authnContext.getAuthnContextClassRef(), (String)this.authnContextClassRef);
    }

    public void assertAttributeStatements(@Nullable List<AttributeStatement> attributeStatements) {
        Assert.assertNotNull(attributeStatements);
        Assert.assertFalse((boolean)attributeStatements.isEmpty());
        Assert.assertEquals((int)attributeStatements.size(), (int)1);
        Assert.assertNotNull((Object)attributeStatements.get(0));
    }

    public void assertAttributeStatement(@Nullable AttributeStatement attributeStatement) {
        Assert.assertNotNull((Object)attributeStatement);
        Assert.assertNotNull((Object)attributeStatement.getAttributes());
    }

    public void assertAttributes(@Nullable List<Attribute> attributes) {
        Assert.assertNotNull(attributes);
        Assert.assertFalse((boolean)attributes.isEmpty());
        Assert.assertEquals((int)attributes.size(), (int)(this.usedAttributeDesignators ? this.expectedDesignatedAttributes.size() : this.expectedAttributes.size()));
        HashMap<String, Attribute> actualAttributes = new HashMap<String, Attribute>();
        for (Attribute attribute : attributes) {
            actualAttributes.put(attribute.getName(), attribute);
        }
        for (int i = 0; i < (this.usedAttributeDesignators ? this.expectedDesignatedAttributes.size() : this.expectedAttributes.size()); ++i) {
            Attribute expectedAttribute = this.usedAttributeDesignators ? this.expectedDesignatedAttributes.get(i) : this.expectedAttributes.get(i);
            Attribute actualAttribute = (Attribute)actualAttributes.get(expectedAttribute.getName());
            Assert.assertNotNull((Object)actualAttribute);
            this.assertAttributeName(actualAttribute, expectedAttribute.getName(), expectedAttribute.getNameFormat(), expectedAttribute.getFriendlyName());
            this.assertAttributeValue(actualAttribute, ((XSAny)expectedAttribute.getAttributeValues().get(0)).getTextContent());
        }
    }

    public void assertAttributeName(@Nullable Attribute attribute, @Nonnull String name, @Nonnull String nameFormat, @Nonnull String friendlyName) {
        Assert.assertNotNull((Object)attribute);
        Assert.assertEquals((String)attribute.getName(), (String)name);
        Assert.assertEquals((String)attribute.getNameFormat(), (String)nameFormat);
        Assert.assertEquals((String)attribute.getFriendlyName(), (String)friendlyName);
    }

    public void assertAttributeValue(@Nullable Attribute attribute, @Nonnull String attributeValue) {
        Assert.assertEquals((int)attribute.getAttributeValues().size(), (int)1);
        Assert.assertTrue((boolean)(attribute.getAttributeValues().get(0) instanceof XSAny));
        Assert.assertEquals((String)((XSAny)attribute.getAttributeValues().get(0)).getTextContent(), (String)attributeValue);
    }
}

