/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.flows.saml2;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.testng.Assert;

public class SAML2TestStatusResponseTypeValidator {
    @Nonnull
    public String idpEntityID = "https://idp.example.org";
    @Nonnull
    public String spEntityID = "https://sp.example.org";
    @Nonnull
    public String statusCode = "urn:oasis:names:tc:SAML:2.0:status:Success";
    @Nonnull
    public String statusCodeNested = "urn:oasis:names:tc:SAML:2.0:status:RequestDenied";
    @Nonnull
    public String statusMessage = "An error occurred.";
    @Nullable
    public String destination;

    public void validateResponse(@Nullable StatusResponseType response) {
        this.assertResponse(response);
        this.assertStatus(response.getStatus());
    }

    public void assertResponse(@Nullable StatusResponseType response) {
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getID());
        Assert.assertFalse((boolean)response.getID().isEmpty());
        Assert.assertNotNull((Object)response.getIssueInstant());
        Assert.assertEquals((Object)response.getVersion(), (Object)SAMLVersion.VERSION_20);
        Assert.assertEquals((String)response.getIssuer().getValue(), (String)this.idpEntityID);
        if (this.destination != null) {
            Assert.assertEquals((String)response.getDestination(), (String)this.destination);
        }
    }

    public void assertStatus(@Nullable Status status) {
        Assert.assertNotNull((Object)status);
        Assert.assertNotNull((Object)status.getStatusCode());
        Assert.assertEquals((String)status.getStatusCode().getValue(), (String)this.statusCode);
        if (this.statusCode != "urn:oasis:names:tc:SAML:2.0:status:Success") {
            Assert.assertEquals((String)status.getStatusMessage().getMessage(), (String)this.statusMessage);
            Assert.assertEquals((String)status.getStatusCode().getStatusCode().getValue(), (String)this.statusCodeNested);
        }
    }
}

