/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.test.spring;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import net.shibboleth.idp.spring.IdPPropertiesApplicationContextInitializer;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class IdPPropertiesApplicationContextInitializerTest {
    private MockServletContext sc;
    private ContextLoaderListener listener;

    @BeforeMethod
    public void setUp() {
        this.sc = new MockServletContext("");
        this.sc.addInitParameter("contextConfigLocation", "classpath:/system/conf/global-system.xml");
        this.sc.addInitParameter("contextInitializerClasses", IdPPropertiesApplicationContextInitializer.class.getName());
        this.listener = new ContextLoaderListener();
    }

    @Test(expectedExceptions={BeanDefinitionStoreException.class})
    public void testNoInitializer() {
        this.sc = new MockServletContext("");
        this.sc.addInitParameter("contextConfigLocation", "classpath:/system/conf/global-system.xml");
        this.listener = new ContextLoaderListener();
        this.listener.contextInitialized(new ServletContextEvent((ServletContext)this.sc));
        WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.sc);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNotFound() {
        this.listener.contextInitialized(new ServletContextEvent((ServletContext)this.sc));
        WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.sc);
    }

    @Test(expectedExceptions={BeanDefinitionStoreException.class})
    public void testNotFoundFalseFailFast() {
        this.sc.addInitParameter("idp.initializer.failFast", "false");
        this.listener.contextInitialized(new ServletContextEvent((ServletContext)this.sc));
        WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.sc);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testUserDefinedNotFound() {
        this.sc.addInitParameter("idp.home", "foo");
        this.listener.contextInitialized(new ServletContextEvent((ServletContext)this.sc));
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.sc);
        Assert.assertTrue((boolean)wac.getEnvironment().containsProperty("idp.home"));
    }

    @Test(expectedExceptions={BeanDefinitionStoreException.class})
    public void testUserDefinedNotFoundFalseFailFast() {
        this.sc.addInitParameter("idp.home", "foo");
        this.sc.addInitParameter("idp.initializer.failFast", "false");
        this.listener.contextInitialized(new ServletContextEvent((ServletContext)this.sc));
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.sc);
        Assert.assertTrue((boolean)wac.getEnvironment().containsProperty("idp.home"));
    }

    @Test
    public void testUserDefinedFound() {
        this.sc.addInitParameter("idp.home", "classpath:");
        this.listener.contextInitialized(new ServletContextEvent((ServletContext)this.sc));
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.sc);
        Assert.assertTrue((boolean)wac.getEnvironment().containsProperty("idp.home"));
        Assert.assertEquals((String)wac.getEnvironment().getProperty("idp.home"), (String)"classpath:");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testUserDefinedEndsWithSlash() {
        this.sc.addInitParameter("idp.home", "/ends-with-slash/");
        this.listener.contextInitialized(new ServletContextEvent((ServletContext)this.sc));
        WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.sc);
    }

    @Test(expectedExceptions={BeanDefinitionStoreException.class})
    public void testUserDefinedEndsWithSlashFalseFailFast() {
        this.sc.addInitParameter("idp.home", "/ends-with-slash/");
        this.sc.addInitParameter("idp.initializer.failFast", "false");
        this.listener.contextInitialized(new ServletContextEvent((ServletContext)this.sc));
        WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.sc);
    }

    @Test
    public void testAdditionalProperties() {
        this.sc.addInitParameter("idp.home", "classpath:");
        this.listener.contextInitialized(new ServletContextEvent((ServletContext)this.sc));
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.sc);
        Assert.assertEquals((String)wac.getEnvironment().getProperty("idp.authn.LDAP.ldapURL"), (String)"ldap://localhost:10389");
    }
}

