/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.flow.impl.AbstractConsentAction;
import net.shibboleth.idp.consent.logic.impl.FlowIdLookupFunction;
import net.shibboleth.idp.consent.storage.impl.ConsentSerializer;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsentStorageAction
extends AbstractConsentAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractConsentStorageAction.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> storageContextLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> storageKeyLookupStrategy;
    @NonnullAfterInit
    private StorageSerializer storageSerializer;
    @Nullable
    private StorageService storageService;
    @Nullable
    private String storageContext;
    @Nullable
    private String storageKey;

    public AbstractConsentStorageAction() {
        this.setStorageContextLookupStrategy((Function<ProfileRequestContext, String>)new FlowIdLookupFunction());
        this.setStorageSerializer(new ConsentSerializer());
    }

    @NonnullAfterInit
    public Function<ProfileRequestContext, String> getStorageContextLookupStrategy() {
        return this.storageContextLookupStrategy;
    }

    @NonnullAfterInit
    public Function<ProfileRequestContext, String> getStorageKeyLookupStrategy() {
        return this.storageKeyLookupStrategy;
    }

    @NonnullAfterInit
    public StorageSerializer getStorageSerializer() {
        return this.storageSerializer;
    }

    public void setStorageContextLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storageContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Storage context lookup strategy cannot be null");
    }

    public void setStorageKeyLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storageKeyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Storage key lookup strategy cannot be null");
    }

    public void setStorageSerializer(@Nonnull StorageSerializer serializer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storageSerializer = (StorageSerializer)Constraint.isNotNull((Object)serializer, (String)"Storage serializer cannot be null");
    }

    @Nullable
    public StorageService getStorageService() {
        return this.storageService;
    }

    @Nullable
    public String getStorageContext() {
        return this.storageContext;
    }

    @Nullable
    public String getStorageKey() {
        return this.storageKey;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storageSerializer == null) {
            throw new ComponentInitializationException("Storage serializer cannot be null");
        }
        if (this.storageContextLookupStrategy == null) {
            throw new ComponentInitializationException("Storage context lookup strategy cannot be null");
        }
        if (this.storageKeyLookupStrategy == null) {
            throw new ComponentInitializationException("Storage key lookup strategy cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        if (!super.doPreExecute(profileRequestContext, interceptorContext)) {
            return false;
        }
        ProfileInterceptorFlowDescriptor flowDescriptor = interceptorContext.getAttemptedFlow();
        this.log.trace("{} Flow descriptor '{}'", (Object)this.getLogPrefix(), (Object)flowDescriptor);
        if (flowDescriptor == null) {
            this.log.warn("{} No flow descriptor available from interceptor context", (Object)this.getLogPrefix());
            return false;
        }
        this.storageService = flowDescriptor.getStorageService();
        this.log.trace("{} Storage service '{}'", (Object)this.getLogPrefix(), (Object)this.storageService);
        if (this.storageService == null) {
            this.log.debug("{} No storage service available from interceptor context", (Object)this.getLogPrefix());
            return false;
        }
        this.storageContext = (String)this.storageContextLookupStrategy.apply((Object)profileRequestContext);
        this.log.trace("{} Storage context '{}'", (Object)this.getLogPrefix(), (Object)this.storageContext);
        if (this.storageContext == null) {
            this.log.debug("{} No storage context", (Object)this.getLogPrefix());
            return false;
        }
        this.storageKey = (String)this.storageKeyLookupStrategy.apply((Object)profileRequestContext);
        this.log.trace("{} Storage key '{}'", (Object)this.getLogPrefix(), (Object)this.storageKey);
        if (this.storageKey == null) {
            this.log.debug("{} No storage key", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }
}

