/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.cryptacular.util.CodecUtil;
import org.cryptacular.util.HashUtil;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.NameIDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class AttributeValuesHashFunction
implements Function<Collection<IdPAttributeValue<?>>, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeValuesHashFunction.class);

    @Nullable
    public String apply(@Nullable @NullableElements Collection<IdPAttributeValue<?>> input) {
        if (input == null) {
            return null;
        }
        Collection filteredInput = Collections2.filter(input, (Predicate)Predicates.notNull());
        if (filteredInput.isEmpty()) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            for (IdPAttributeValue value : filteredInput) {
                if (value instanceof ScopedStringAttributeValue) {
                    objectOutputStream.writeObject(((ScopedStringAttributeValue)value).getValue() + '@' + ((ScopedStringAttributeValue)value).getScope());
                    continue;
                }
                if (value instanceof XMLObjectAttributeValue) {
                    if (value.getValue() instanceof NameIDType) {
                        objectOutputStream.writeObject(((NameIDType)value.getValue()).getValue());
                        continue;
                    }
                    try {
                        objectOutputStream.writeObject(SerializeSupport.nodeToString((Node)XMLObjectSupport.marshall((XMLObject)((XMLObjectAttributeValue)value).getValue())));
                        continue;
                    }
                    catch (MarshallingException e) {
                        this.log.error("Error while marshalling XMLObject value", (Throwable)e);
                        return null;
                    }
                }
                if (value.getValue() == null) continue;
                objectOutputStream.writeObject(value.getValue());
            }
            objectOutputStream.flush();
            objectOutputStream.close();
            byteArrayOutputStream.close();
            return CodecUtil.b64((byte[])HashUtil.sha256((Object[])new Object[]{byteArrayOutputStream.toByteArray()}));
        }
        catch (IOException e) {
            this.log.error("Error while converting attribute values into a byte array", (Throwable)e);
            return null;
        }
    }
}

