/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.saml.attribute.mapping.AttributesMapContainer;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.navigate.AttributeConsumerServiceLookupFunction;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsAttributeRequiredPredicate
implements Predicate<IdPAttribute> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IsAttributeRequiredPredicate.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(SAMLMetadataContext.class), (Function)Functions.compose((Function)new ChildContextLookup(SAMLPeerEntityContext.class), (Function)new OutboundMessageContextLookup()));
    @Nonnull
    private Function<SAMLMetadataContext, AttributeConsumingService> acsLookupStrategy = Functions.compose((Function)new AttributeConsumerServiceLookupFunction(), (Function)new ChildContextLookup(AttributeConsumingServiceContext.class));
    @Nullable
    private final Multimap<String, IdPRequestedAttribute> requestedAttributesMap;

    public IsAttributeRequiredPredicate(@Nullable HttpServletRequest request) {
        ProfileRequestContext prc = this.getProfileRequestContext(request);
        this.requestedAttributesMap = this.getRequestedAttributes(prc);
    }

    @Nullable
    protected ProfileRequestContext getProfileRequestContext(@Nullable HttpServletRequest httpRequest) {
        if (httpRequest != null) {
            Object object = httpRequest.getAttribute("opensamlProfileRequestContext");
            if (object != null && object instanceof ProfileRequestContext) {
                return (ProfileRequestContext)object;
            }
            this.log.warn("Unable to find ProfileRequestContext in HTTP request");
        } else {
            this.log.warn("HTTP request is not available");
        }
        return null;
    }

    @Nullable
    protected Multimap<String, IdPRequestedAttribute> getRequestedAttributes(@Nullable ProfileRequestContext prc) {
        List maps;
        AttributeConsumingService acs;
        SAMLMetadataContext metadataContext;
        if (prc != null && (metadataContext = (SAMLMetadataContext)this.metadataContextLookupStrategy.apply((Object)prc)) != null && (acs = (AttributeConsumingService)this.acsLookupStrategy.apply((Object)metadataContext)) != null && (maps = acs.getObjectMetadata().get(AttributesMapContainer.class)) != null && !maps.isEmpty()) {
            if (maps.size() > 1) {
                this.log.warn("More than one set of mapped attributes found, using the first.");
            }
            return ((AttributesMapContainer)maps.get(0)).get();
        }
        return null;
    }

    public boolean apply(@Nullable IdPAttribute input) {
        Collection requestedAttrs;
        if (input != null && this.requestedAttributesMap != null && !this.requestedAttributesMap.isEmpty() && (requestedAttrs = this.requestedAttributesMap.get((Object)input.getId())) != null) {
            for (IdPRequestedAttribute requestedAttr : requestedAttrs) {
                if (requestedAttr == null || !requestedAttr.getIsRequired()) continue;
                this.log.debug("Attribute '{}' is required", (Object)input);
                return true;
            }
        }
        this.log.debug("Attribute '{}' is not required", (Object)input);
        return false;
    }
}

