/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.consent.logic.impl.AttributeDisplayDescriptionFunction;
import net.shibboleth.idp.consent.logic.impl.AttributeDisplayNameFunction;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AttributeDisplayNameDescriptionFunctionTest {
    private IdPAttribute testAttribute;

    @BeforeClass
    public void constructAttribute() {
        IdPAttribute attr = new IdPAttribute("What");
        HashMap<Locale, String> names = new HashMap<Locale, String>(3);
        names.put(new Locale("en"), "EN locale Name");
        names.put(new Locale("fr"), "FR locale Name");
        names.put(new Locale("de"), "DE locale Name");
        HashMap<Locale, String> descriptions = new HashMap<Locale, String>(3);
        descriptions.put(new Locale("en"), "EN locale Description");
        descriptions.put(new Locale("fr"), "FR locale Description");
        descriptions.put(new Locale("de"), "DE locale Description");
        attr.setDisplayNames(names);
        attr.setDisplayDescriptions(descriptions);
        this.testAttribute = attr;
    }

    private HttpServletRequest getMockRequest(String ... languages) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        ArrayList<Locale> locales = new ArrayList<Locale>(languages.length);
        for (String language : languages) {
            locales.add(new Locale(language));
        }
        request.setPreferredLocales(locales);
        return request;
    }

    @Test
    public void testNameHttpOnly() {
        AttributeDisplayNameFunction func = new AttributeDisplayNameFunction(this.getMockRequest("fr", "de", "en"), null);
        Assert.assertEquals((String)((String)func.apply((Object)this.testAttribute)), (String)"FR locale Name");
        func = new AttributeDisplayNameFunction(this.getMockRequest("pt", "es"), null);
        Assert.assertEquals((String)((String)func.apply((Object)this.testAttribute)), (String)this.testAttribute.getId());
    }

    @Test
    public void testNameWithDefault() {
        ArrayList fallback = Lists.newArrayList((Object[])new String[]{"en", "fr", "de"});
        AttributeDisplayNameFunction func = new AttributeDisplayNameFunction(this.getMockRequest("fr", "de", "en"), (List)fallback);
        Assert.assertEquals((String)((String)func.apply((Object)this.testAttribute)), (String)"FR locale Name");
        func = new AttributeDisplayNameFunction(this.getMockRequest("pt", "es"), (List)fallback);
        Assert.assertEquals((String)((String)func.apply((Object)this.testAttribute)), (String)"EN locale Name");
    }

    @Test
    public void testDescHttpOnly() {
        AttributeDisplayDescriptionFunction func = new AttributeDisplayDescriptionFunction(this.getMockRequest("fr", "de", "en"), null);
        Assert.assertEquals((String)((String)func.apply((Object)this.testAttribute)), (String)"FR locale Description");
        func = new AttributeDisplayDescriptionFunction(this.getMockRequest("pt", "es"), null);
        Assert.assertEquals((String)((String)func.apply((Object)this.testAttribute)), (String)this.testAttribute.getId());
    }

    @Test
    public void testDescWithDefault() {
        ArrayList fallback = Lists.newArrayList((Object[])new String[]{"en", "fr", "de"});
        AttributeDisplayDescriptionFunction func = new AttributeDisplayDescriptionFunction(this.getMockRequest("fr", "de", "en"), (List)fallback);
        Assert.assertEquals((String)((String)func.apply((Object)this.testAttribute)), (String)"FR locale Description");
        func = new AttributeDisplayDescriptionFunction(this.getMockRequest("pt", "es"), (List)fallback);
        Assert.assertEquals((String)((String)func.apply((Object)this.testAttribute)), (String)"EN locale Description");
    }

    @Test
    public void testNullFallbackLanguage() {
        ArrayList fallback = Lists.newArrayList((Object[])new String[]{null, "fr"});
        AttributeDisplayNameFunction displayNameFunc = new AttributeDisplayNameFunction(this.getMockRequest("pt", "es"), (List)fallback);
        Assert.assertEquals((String)((String)displayNameFunc.apply((Object)this.testAttribute)), (String)"FR locale Name");
        AttributeDisplayDescriptionFunction descFunc = new AttributeDisplayDescriptionFunction(this.getMockRequest("pt", "es"), (List)fallback);
        Assert.assertEquals((String)((String)descFunc.apply((Object)this.testAttribute)), (String)"FR locale Description");
    }
}

