/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.consent.logic.impl.AttributeValuesHashFunction;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeValuesHashFunctionTest {
    private AttributeValuesHashFunction function;

    @BeforeMethod
    public void setUp() {
        this.function = new AttributeValuesHashFunction();
    }

    @Test
    public void testNullInput() {
        Assert.assertNull((Object)this.function.apply(null));
    }

    @Test
    public void testEmptyInput() {
        Assert.assertNull((Object)this.function.apply((Collection)Collections.EMPTY_LIST));
    }

    @Test
    public void testNullValue() {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(null);
        Assert.assertNull((Object)this.function.apply(values));
    }

    @Test
    public void testSingleValue() {
        String hash = this.function.apply((Collection)ConsentTestingSupport.newAttributeMap().get("attribute1").getValues());
        Assert.assertEquals((String)hash, (String)"yePBj0hcjLihhDtDb//R/ymyw2CHZAUreX/4RupmSXM=");
    }

    @Test
    public void testMultipleValues() {
        String hash = this.function.apply((Collection)ConsentTestingSupport.newAttributeMap().get("attribute2").getValues());
        Assert.assertEquals((String)hash, (String)"xxuA06hGJ1DcJ4JSaWiBXXGfcRr6oxHM5jaURXBBnbA=");
    }
}

