/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import net.shibboleth.idp.consent.logic.impl.FlowIdLookupFunction;
import net.shibboleth.idp.profile.RequestContextBuilder;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FlowIdLookupFunctionTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private FlowIdLookupFunction function;

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.function = new FlowIdLookupFunction();
    }

    @Test
    public void testNullInput() {
        Assert.assertNull((Object)this.function.apply(null));
    }

    @Test
    public void testNullSpringRequestContext() {
        Assert.assertNull((Object)this.prc.getSubcontext(SpringRequestContext.class));
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testNullWebFlowRequestContext() {
        this.prc.getSubcontext(SpringRequestContext.class, true);
        Assert.assertNotNull((Object)this.prc.getSubcontext(SpringRequestContext.class));
        Assert.assertNull((Object)((SpringRequestContext)this.prc.getSubcontext(SpringRequestContext.class)).getRequestContext());
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test(enabled=false)
    public void testNullFlowExecutionContext() {
    }

    @Test(enabled=false)
    public void testNonActiveFlowExecutionContext() {
    }

    @Test
    public void testFlowId() {
        ((SpringRequestContext)this.prc.getSubcontext(SpringRequestContext.class, true)).setRequestContext(this.src);
        Assert.assertNotNull((Object)this.prc.getSubcontext(SpringRequestContext.class));
        Assert.assertNotNull((Object)((SpringRequestContext)this.prc.getSubcontext(SpringRequestContext.class)).getRequestContext());
        Assert.assertEquals((String)this.function.apply(this.prc), (String)"mockFlow");
    }
}

