/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.storage.impl;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.consent.logic.impl.AttributeValuesHashFunction;
import net.shibboleth.idp.consent.storage.impl.ConsentSerializer;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ConsentSerializerTest {
    @Nonnull
    protected final Logger log = LoggerFactory.getLogger(ConsentSerializerTest.class);
    private static final String CONTEXT = "_context";
    private static final String KEY = "_key";
    protected ConsentSerializer serializer;
    protected IdPAttribute attribute1;
    protected IdPAttribute attribute2;
    protected IdPAttributeValue<?> value1;
    protected IdPAttributeValue<?> value2;
    protected IdPAttributeValue<?> value3;
    protected Consent consent1;
    protected Consent consent2;
    protected DateTime expiration;
    protected Map<String, Consent> consents;
    protected Function<Collection<IdPAttributeValue<?>>, String> attributeValuesHashFunction;

    @BeforeMethod
    public void setUp() {
        this.serializer = new ConsentSerializer();
        this.attributeValuesHashFunction = new AttributeValuesHashFunction();
        Map<String, IdPAttribute> attributes = ConsentTestingSupport.newAttributeMap();
        this.consent1 = new Consent();
        this.consent1.setId("attribute1");
        this.consent1.setValue((String)this.attributeValuesHashFunction.apply((Object)attributes.get("attribute1").getValues()));
        this.consent1.setApproved(true);
        this.consent2 = new Consent();
        this.consent2.setId("attribute2");
        this.consent2.setValue((String)this.attributeValuesHashFunction.apply((Object)attributes.get("attribute2").getValues()));
        this.consent2.setApproved(false);
        this.consents = new LinkedHashMap<String, Consent>();
        this.consents.put(this.consent1.getId(), this.consent1);
        this.consents.put(this.consent2.getId(), this.consent2);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNull() throws Exception {
        this.serializer.initialize();
        this.serializer.serialize(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testEmpty() throws Exception {
        this.serializer.initialize();
        this.serializer.serialize(new HashMap());
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullSymoblics() throws Exception {
        this.serializer.setSymbolics(null);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testMutatingSymoblics() throws Exception {
        this.serializer.initialize();
        this.serializer.setSymbolics(new HashMap());
    }

    @Test
    public void testSimple() throws Exception {
        this.serializer.initialize();
        String serialized = this.serializer.serialize(this.consents);
        Assert.assertEquals((String)serialized, (String)"[{\"id\":\"attribute1\",\"v\":\"yePBj0hcjLihhDtDb//R/ymyw2CHZAUreX/4RupmSXM=\"},{\"id\":\"attribute2\",\"v\":\"xxuA06hGJ1DcJ4JSaWiBXXGfcRr6oxHM5jaURXBBnbA=\",\"appr\":false}]");
        Map deserialized = this.serializer.deserialize(1L, CONTEXT, KEY, serialized, null);
        Assert.assertEquals(this.consents, (Map)deserialized);
    }

    @Test
    public void testSymbolics() throws Exception {
        this.serializer.setSymbolics(ConsentTestingSupport.newSymbolicsMap());
        this.serializer.initialize();
        String serialized = this.serializer.serialize(this.consents);
        Assert.assertEquals((String)serialized, (String)"[{\"id\":201,\"v\":\"yePBj0hcjLihhDtDb//R/ymyw2CHZAUreX/4RupmSXM=\"},{\"id\":202,\"v\":\"xxuA06hGJ1DcJ4JSaWiBXXGfcRr6oxHM5jaURXBBnbA=\",\"appr\":false}]");
        Map deserialized = this.serializer.deserialize(1L, CONTEXT, KEY, serialized, null);
        Assert.assertEquals(this.consents, (Map)deserialized);
    }

    @Test
    public void testSymbolicsWithNulls() throws Exception {
        HashMap<String, Integer> symbolics = new HashMap<String, Integer>();
        symbolics.put("attribute1", null);
        symbolics.put(null, 222);
        this.serializer.setSymbolics(symbolics);
        this.serializer.initialize();
        String serialized = this.serializer.serialize(this.consents);
        Assert.assertEquals((String)serialized, (String)"[{\"id\":\"attribute1\",\"v\":\"yePBj0hcjLihhDtDb//R/ymyw2CHZAUreX/4RupmSXM=\"},{\"id\":\"attribute2\",\"v\":\"xxuA06hGJ1DcJ4JSaWiBXXGfcRr6oxHM5jaURXBBnbA=\",\"appr\":false}]");
        Map deserialized = this.serializer.deserialize(1L, CONTEXT, KEY, serialized, null);
        Assert.assertEquals(this.consents, (Map)deserialized);
    }
}

