/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeValueLookupFunction
implements ContextDataLookupFunction<ProfileRequestContext, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeValueLookupFunction.class);
    @Nonnull
    @NotEmpty
    private String attributeId;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    private boolean useUnfilteredAttributes;

    public AttributeValueLookupFunction(@Nonnull @NotEmpty String userAttributeId) {
        this.attributeId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)userAttributeId), (String)"User attribute ID cannot be null nor empty");
        this.attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(RelyingPartyContext.class));
        this.useUnfilteredAttributes = true;
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Attribute context lookup strategy cannot be null");
    }

    public void setUseUnfilteredAttributes(boolean flag) {
        this.useUnfilteredAttributes = flag;
    }

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        AttributeContext attributeContext = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)input);
        if (attributeContext == null) {
            this.log.debug("No attribute context within profile request context");
            return null;
        }
        Map attributes = this.useUnfilteredAttributes ? attributeContext.getUnfilteredIdPAttributes() : attributeContext.getIdPAttributes();
        IdPAttribute attribute = (IdPAttribute)attributes.get(this.attributeId);
        if (attribute == null || attribute.getValues().isEmpty()) {
            this.log.debug("Attribute '{}' does not exist or has no values", (Object)this.attributeId);
            return null;
        }
        if (attribute.getValues().size() != 1) {
            this.log.debug("Returning first string value of attribute '{}'", (Object)this.attributeId);
        }
        for (IdPAttributeValue value : attribute.getValues()) {
            if (!(value instanceof StringAttributeValue)) continue;
            this.log.debug("Returning value '{}' of attribute '{}'", (Object)((StringAttributeValue)value).getValue(), (Object)this.attributeId);
            return ((StringAttributeValue)value).getValue();
        }
        return null;
    }
}

