/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.impl;

import com.google.common.base.Function;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.impl.AbstractConsentActionTest;
import net.shibboleth.idp.consent.flow.impl.PopulateConsentContext;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.profile.ActionTestingSupport;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PopulateConsentContextTest
extends AbstractConsentActionTest {
    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullCurrentConsentsFunction() throws Exception {
        this.action = new PopulateConsentContext(null);
        this.action.initialize();
    }

    @Test
    public void testCurrentConsentsFunction() throws Exception {
        this.action = new PopulateConsentContext((Function)new MockCurrentConsentsFunction());
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class, false);
        Assert.assertNotNull((Object)consentContext);
        Assert.assertEquals((Map)consentContext.getCurrentConsents(), ConsentTestingSupport.newConsentMap());
    }

    private class MockCurrentConsentsFunction
    implements Function<ProfileRequestContext, Map<String, Consent>> {
        private MockCurrentConsentsFunction() {
        }

        public Map<String, Consent> apply(@Nonnull ProfileRequestContext input) {
            return ConsentTestingSupport.newConsentMap();
        }
    }
}

