/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentIndexedStorageActionTest;
import net.shibboleth.idp.consent.flow.storage.impl.CreateGlobalConsentResult;
import net.shibboleth.idp.profile.ActionTestingSupport;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CreateGlobalConsentResultTest
extends AbstractConsentIndexedStorageActionTest {
    @BeforeMethod
    public void setUpAction() throws Exception {
        this.action = new CreateGlobalConsentResult();
        this.populateAction();
    }

    @Test
    public void testCreateGlobalConsentResult() throws Exception {
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ProfileInterceptorContext pic = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class, false);
        Assert.assertNotNull((Object)pic);
        Assert.assertEquals((int)pic.getResults().size(), (int)0);
        Collection<String> keys = this.readStorageKeysFromIndex();
        Assert.assertEquals(keys, Arrays.asList("key"));
        Map<String, Consent> consents = this.readConsentsFromStorage();
        Assert.assertEquals((int)consents.size(), (int)1);
        Consent globalConsent = consents.values().iterator().next();
        Assert.assertNotNull((Object)globalConsent);
        Assert.assertEquals((String)globalConsent.getId(), (String)"*");
        Assert.assertNull((Object)globalConsent.getValue());
        Assert.assertTrue((boolean)globalConsent.isApproved());
    }
}

