/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;

public abstract class AbstractAttributeDisplayFunction
implements Function<IdPAttribute, String> {
    @Nonnull
    private final List<Locale> locales;

    public AbstractAttributeDisplayFunction(@Nonnull HttpServletRequest request, @Nullable List<String> defaultLanguages) {
        ArrayList<Locale> newLocales = new ArrayList<Locale>();
        Enumeration requestLocales = request.getLocales();
        while (requestLocales.hasMoreElements()) {
            newLocales.add((Locale)requestLocales.nextElement());
        }
        if (null != defaultLanguages) {
            for (String s : defaultLanguages) {
                if (null == s) continue;
                newLocales.add(new Locale(s));
            }
        }
        this.locales = newLocales;
    }

    @Nonnull
    @NotEmpty
    public String apply(@Nullable IdPAttribute input) {
        if (input == null) {
            return "N/A";
        }
        Map<Locale, String> displayInfo = this.getDisplayInfo(input);
        if (null != displayInfo && !displayInfo.isEmpty()) {
            for (Locale locale : this.locales) {
                String toBeDisplayed = displayInfo.get(locale);
                if (toBeDisplayed != null) {
                    return toBeDisplayed;
                }
                toBeDisplayed = displayInfo.get(Locale.forLanguageTag(locale.getLanguage()));
                if (toBeDisplayed == null) continue;
                return toBeDisplayed;
            }
        }
        return input.getId();
    }

    @Nonnull
    protected abstract Map<Locale, String> getDisplayInfo(@Nonnull IdPAttribute var1);
}

