/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.ar.impl;

import java.util.HashMap;
import java.util.Map;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.AttributeReleaseContext;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.ar.impl.AbstractAttributeReleaseActionTest;
import net.shibboleth.idp.consent.flow.ar.impl.ReleaseAttributes;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.profile.ActionTestingSupport;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReleaseAttributesTest
extends AbstractAttributeReleaseActionTest {
    private AttributeReleaseContext arc;

    @BeforeMethod
    void setUpAction() throws Exception {
        this.action = new ReleaseAttributes();
        Consent consentToAttribute1 = new Consent();
        consentToAttribute1.setId("attribute1");
        consentToAttribute1.setApproved(true);
        Consent consentToAttribute2 = new Consent();
        consentToAttribute2.setId("attribute2");
        consentToAttribute2.setApproved(false);
        HashMap<String, Consent> consent = new HashMap<String, Consent>();
        consent.put(consentToAttribute1.getId(), consentToAttribute1);
        consent.put(consentToAttribute2.getId(), consentToAttribute2);
        ConsentContext consentCtx = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        consentCtx.getPreviousConsents().putAll(consent);
        this.arc = (AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class);
    }

    @Test
    public void testAllAttributesAreConsentable() throws Exception {
        Map<String, IdPAttribute> consentableAttributes = ConsentTestingSupport.newAttributeMap();
        this.arc.getConsentableAttributes().clear();
        this.arc.getConsentableAttributes().putAll(consentableAttributes);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AttributeContext attrCtx = (AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class);
        Assert.assertNotNull((Object)attrCtx);
        Assert.assertEquals((int)attrCtx.getIdPAttributes().size(), (int)1);
        Assert.assertTrue((boolean)attrCtx.getIdPAttributes().containsKey("attribute1"));
        Assert.assertFalse((boolean)attrCtx.getIdPAttributes().containsKey("attribute2"));
        Assert.assertFalse((boolean)attrCtx.getIdPAttributes().containsKey("attribute3"));
    }

    @Test
    public void testSomeAttributesAreConsentable() throws Exception {
        Map<String, IdPAttribute> consentableAttributes = ConsentTestingSupport.newAttributeMap();
        consentableAttributes.remove("attribute2");
        this.arc.getConsentableAttributes().clear();
        this.arc.getConsentableAttributes().putAll(consentableAttributes);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AttributeContext attrCtx = (AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class);
        Assert.assertNotNull((Object)attrCtx);
        Assert.assertEquals((int)attrCtx.getIdPAttributes().size(), (int)2);
        Assert.assertTrue((boolean)attrCtx.getIdPAttributes().containsKey("attribute1"));
        Assert.assertTrue((boolean)attrCtx.getIdPAttributes().containsKey("attribute2"));
        Assert.assertFalse((boolean)attrCtx.getIdPAttributes().containsKey("attribute3"));
    }
}

