/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.impl;

import java.time.Duration;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ConsentFlowDescriptorTest {
    private ConsentFlowDescriptor descriptor;

    @BeforeMethod
    public void setUp() {
        this.descriptor = new ConsentFlowDescriptor();
        this.descriptor.setId("test");
    }

    @Test
    public void testInstantation() {
        Assert.assertEquals((String)this.descriptor.getId(), (String)"test");
        Assert.assertFalse((boolean)this.descriptor.compareValues());
        Assert.assertEquals((Object)Duration.ofDays(365L), (Object)this.descriptor.getLifetime());
    }

    @Test
    public void testCompareValues() {
        this.descriptor.setCompareValues(true);
        Assert.assertTrue((boolean)this.descriptor.compareValues());
        this.descriptor.setCompareValues(false);
        Assert.assertFalse((boolean)this.descriptor.compareValues());
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullLifetime() {
        this.descriptor.setLifetime(null);
    }

    @Test
    public void testLifetime() {
        Duration lifetime = Duration.ofSeconds(1L);
        this.descriptor.setLifetime(lifetime);
        Assert.assertEquals((Object)this.descriptor.getLifetime(), (Object)lifetime);
        lifetime = Duration.ZERO;
        this.descriptor.setLifetime(lifetime);
        Assert.assertEquals((Object)this.descriptor.getLifetime(), (Object)lifetime);
    }

    @Test
    public void testMaxStoredRecords() {
        this.descriptor.setMaximumNumberOfStoredRecords(1024);
        Assert.assertEquals((int)this.descriptor.getMaximumNumberOfStoredRecords(), (int)1024);
        this.descriptor.setMaximumNumberOfStoredRecords(0);
        Assert.assertEquals((int)this.descriptor.getMaximumNumberOfStoredRecords(), (int)0);
        this.descriptor.setMaximumNumberOfStoredRecords(-1);
        Assert.assertEquals((int)this.descriptor.getMaximumNumberOfStoredRecords(), (int)-1);
    }
}

